package com.liquidnet.service.goblin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinAppOrderListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.dto.vo.GoblinZhengzaiGoodVo;

import java.util.List;

public interface IGoblinStoreZhengzaiService {

    /**
     * 正在下单活动列表
     *
     * @return
     */
    ResponseDto<List<GoblinSelfMarketingVo>> getZhengzaiMarketList();

    /**
     * 正在下单 商铺参与活动的商品列表
     * @param marketId
     * @param keyword 搜索内容，支持`SPU名称`、`SKU名称`、`SKU编码`
     * @return
     */
    ResponseDto<List<GoblinZhengzaiGoodVo>> getSpuList(String marketId, String keyword);

    ResponseDto<List<GoblinAppOrderListVo>> orderList(int page);

    ResponseDto<Boolean> orderPush(String orderMasterCode);
}
