package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinSelfTagService;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfTagVo;
import com.liquidnet.service.goblin.entity.GoblinSelfTag;
import com.liquidnet.service.goblin.mapper.GoblinSelfTagMapper;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 平台商品标签 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Slf4j
@Service
public class GoblinSelfGoodsTagServiceImpl extends ServiceImpl<GoblinSelfTagMapper, GoblinSelfTag> implements IGoblinSelfTagService {
    @Autowired
    private MongoTemplate mongoTemplate;

    @Transactional
    @Override
    public boolean addSave(GoblinSelfTag selfTag) {
        if (this.save(selfTag)) {
            mongoTemplate.insert(GoblinSelfTagVo.getNew().copy(selfTag), GoblinSelfTagVo.class.getSimpleName());
            // TODO: 2022/1/14 zhanggb redis
            return true;
        }
        return false;
    }

    @Transactional
    @Override
    public boolean editSave(GoblinSelfTag selfTag) {
        LambdaUpdateWrapper<GoblinSelfTag> updateWrapper = Wrappers.lambdaUpdate(GoblinSelfTag.class);
        updateWrapper.eq(GoblinSelfTag::getTagId, selfTag.getTagId());
        updateWrapper.eq(GoblinSelfTag::getTagBelong, selfTag.getTagBelong());
        updateWrapper.eq(GoblinSelfTag::getDelFlg, "0");

        updateWrapper.set(GoblinSelfTag::getTagType, selfTag.getTagType());
        updateWrapper.set(GoblinSelfTag::getTagName, selfTag.getTagName());
        updateWrapper.set(GoblinSelfTag::getTagPic, selfTag.getTagPic());
        if (this.update(updateWrapper)) {
            UpdateResult updateResult = mongoTemplate.getCollection(GoblinSelfTagVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("tagId").is(selfTag.getTagId()).and("tagBelong").is(selfTag.getTagBelong()).and("delFlg").is("0")).getQueryObject(),
                    Update.update("tagType", selfTag.getTagType()).set("tagName", selfTag.getTagName()).set("tagPic", selfTag.getTagPic()).getUpdateObject()
            );
            log.info("店铺管理:标签管理:编辑[selfTag={},MONGO.UpdateResult={}]", JsonUtils.toJson(selfTag), JsonUtils.toJson(updateResult));
            // TODO: 2022/1/14 zhanggb redis
            return true;
        }
        return false;
    }

    @Transactional
    @Override
    public boolean remove(String[] tagIdArr, String tagBelong) {
        boolean rmvResultFlg = this.update(Wrappers.lambdaUpdate(GoblinSelfTag.class)
                .in(GoblinSelfTag::getTagId, tagIdArr)
                .eq(GoblinSelfTag::getTagBelong, tagBelong)
                .eq(GoblinSelfTag::getDelFlg, "0")
                .set(GoblinSelfTag::getDelFlg, "1")
        );

        if (rmvResultFlg) {
            UpdateResult updateResult = mongoTemplate.updateMulti(Query.query(Criteria.where("tagId").in(tagIdArr).and("delFlg").is("0").and("tagBelong").is(tagBelong)),
                    Update.update("delFlg", "1"),
                    GoblinSelfTagVo.class.getSimpleName()
            );
            log.info("店铺管理:标签管理:删除[tagIdArr={},tagBelong={},MONGO.UpdateResult={}]", JsonUtils.toJson(tagIdArr), tagBelong, JsonUtils.toJson(updateResult));
            // TODO: 2022/1/14 zhanggb redis
        }
        return rmvResultFlg;
    }
}
