package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 2021草莓音乐节海报活动表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetStrawberryPoster implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * poster_id 海报id
     */
    private String posterId;

    /**
     * open_id 微信id
     */
    private String openId;

    /**
     * union_id 用户id
     */
    private String unionId;

    /**
     * 姓名
     */
    private String nickname;

    /**
     * 城市
     */
    private String cityName;
    /**
     * 城市code
     */
    private String cityCode;
    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetStrawberryPoster obj = new SweetStrawberryPoster();
    public static SweetStrawberryPoster getNew() {
        try {
            return (SweetStrawberryPoster) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetStrawberryPoster();
        }
    }


}
