package com.liquidnet.service.stone.util;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.entity.StoneScoreLogs;
import com.liquidnet.service.stone.entity.StoneScoreOrder;
import com.liquidnet.service.stone.vo.StoneOrderListVo;
import com.liquidnet.service.stone.vo.StoneUserVo;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

@Component
public class StoneMongoUtils {

    @Autowired
    private MongoTemplate mongoTemplate;

    /**
     * 获取 积分物品
     *
     * @param itemId
     * @return
     */
    public StoneScoreItems itemGet(String itemId) {
        Query query = Query.query(Criteria.where("itemId").ne(itemId));
        return mongoTemplate.findOne(query,
                StoneScoreItems.class, StoneScoreItems.class.getSimpleName());
    }

//    /**
//     * 根据积分物品id修改
//     *
//     * @param data
//     * @return
//     */
//    public Object itemUpdateById(StoneScoreItems data) {
//        Query query = Query.query(Criteria.where("itemId").is(data.getItemId()));
//        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(data)));
//        UpdateResult result = mongoTemplate.updateFirst(query, update, StoneScoreItems.class, StoneScoreItems.class.getSimpleName());
//        return result;
//    }

//    /**
//     * 查询 积分物品 列表
//     *
//     * @return
//     */
//    public List<StoneScoreItems> itemList() {
//        Query query = Query.query(Criteria.where("status").ne(-1));
//        List<StoneScoreItems> voList = mongoTemplate.find(query.with(Sort.by(Sort.Direction.DESC, "createdAt")).limit(40),
//                StoneScoreItems.class, StoneScoreItems.class.getSimpleName());
//        return voList;
//    }

    /**
     * 查询 积分物品 列表分页
     *
     * @return
     */
    public HashMap<String, Object> itemListPage(int page, int size) {
        LocalDateTime now  = LocalDateTime.now();
        HashMap<String, Object> info = CollectionUtil.mapStringObject();
        // 排序 分页
        Pageable pageable = PageRequest.of(page - 1, size, Sort.by(Sort.Direction.DESC, "createdAt"));
        //条件
        Query query = Query.query(new Criteria().orOperator(Criteria.where("status").is(1),Criteria.where("status").is(2).and("startTime").lte(now).and("endTime").gte(now)));
        // 查询总数
        long count = mongoTemplate.count(query, StoneScoreItems.class, StoneScoreItems.class.getSimpleName());
        query.with(pageable);
        List<StoneScoreItems> voList = mongoTemplate.find(query, StoneScoreItems.class, StoneScoreItems.class.getSimpleName());
        info.put("total", count);
        info.put("data", voList);
        return info;
    }

    /**
     * 创建 用户积分
     *
     * @param data
     * @return
     */
    public Object userCreate(StoneUserVo data) {
        return mongoTemplate.insert(data, StoneUserVo.class.getSimpleName());
    }

    /**
     * 根据用户id修改 用户积分
     *
     * @param data
     * @return
     */
    public Object userUpdateByUid(StoneUserVo data) {
        Query query = Query.query(Criteria.where("uid").is(data.getUid()));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(data)));
        UpdateResult result = mongoTemplate.updateFirst(query, update, StoneUserVo.class, StoneUserVo.class.getSimpleName());
        return result;
    }

    /**
     * 创建 用户积分日志
     *
     * @param data
     * @return
     */
    public Object logCreate(StoneScoreLogs data) {
        return mongoTemplate.insert(data, StoneScoreLogs.class.getSimpleName());
    }

    /**
     * 获取 用户积分日志 列表
     * @param uid
     * @param page
     * @param size
     * @return
     */
    public HashMap<String, Object> logList(String uid,int page, int size) {
        LocalDateTime now  = LocalDateTime.now();
        HashMap<String, Object> info = CollectionUtil.mapStringObject();
        // 排序 分页
        Pageable pageable = PageRequest.of(page - 1, size, Sort.by(Sort.Direction.DESC, "createdAt"));
        //条件
        Query query = Query.query(Criteria.where("uid").is(uid));
        // 查询总数
        long count = mongoTemplate.count(query, StoneScoreLogs.class, StoneScoreLogs.class.getSimpleName());
        query.with(pageable);
        List<StoneScoreLogs> voList = mongoTemplate.find(query, StoneScoreLogs.class, StoneScoreLogs.class.getSimpleName());
        info.put("total", count);
        info.put("data", voList);
        return info;
    }

    /**
     * 获取 用户订单 列表
     * @param uid
     * @param page
     * @param size
     * @return
     */
    public HashMap<String, Object> orderList(String uid,int page, int size) {
        LocalDateTime now  = LocalDateTime.now();
        HashMap<String, Object> info = CollectionUtil.mapStringObject();
        // 排序 分页
        Pageable pageable = PageRequest.of(page - 1, size, Sort.by(Sort.Direction.DESC, "createdAt"));
        //条件
        Query query = Query.query(Criteria.where("uid").is(uid));
        // 查询总数
        long count = mongoTemplate.count(query, StoneOrderListVo.class, StoneOrderListVo.class.getSimpleName());
        query.with(pageable);
        List<StoneOrderListVo> voList = mongoTemplate.find(query, StoneOrderListVo.class, StoneOrderListVo.class.getSimpleName());
        info.put("total", count);
        info.put("data", voList);
        return info;
    }

}
