package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.adam.dto.vo.AdamMemberSimpleVo;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.dto.vo.AdamUserMemberVo;
import com.liquidnet.service.adam.service.IAdamMemberService;
import com.liquidnet.service.adam.service.AdamRdmService;
import com.liquidnet.service.adam.service.IAdamUserMemberService;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

@ApiSupport(order = 10030)
@Api(tags = "会员信息")
@Slf4j
@Validated
@RestController
@RequestMapping("member")
public class AdamMemberController {
    @Autowired
    AdamRdmService adamRdmService;
    @Autowired
    IAdamMemberService adamMemberService;
    @Autowired
    IAdamUserMemberService adamUserMemberService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "会员信息")
    @GetMapping("info")
    public ResponseDto<AdamMemberVo> query() {
        AdamMemberSimpleVo memberSimpleVo = adamRdmService.getMemberSimpleVo();
        AdamMemberVo memberVo = null;
        if (null != memberSimpleVo && null != (memberVo = adamRdmService.getMemberVoByMemberId(memberSimpleVo.getMemberId()))) {
            memberVo.setPriceVoList(adamRdmService.getMemberPriceVoByMemberId(memberVo.getMemberId()));

            memberVo.setRightsVoList(adamRdmService.getMemberRightsVoByMemberId(memberVo.getMemberId()));

            String currentUid = CurrentUtil.getCurrentUid();
            if (!StringUtils.isEmpty(currentUid)) {
                memberVo.setUserMemberVo(adamRdmService.getUserMemberVoByUid(currentUid));
            }
        }
        return ResponseDto.success(memberVo);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "会员协议")
    @GetMapping("agreement")
    public ResponseDto<String> agreement() {
        return ResponseDto.success(adamRdmService.getMemberAgreement());
    }

    /* ------------------------------------------------------------｜API */

    @ApiOperationSupport(order = 99)
    @ApiOperation(value = "@API:是否会员", notes = "根据UID判断用户是否会员，响应参数[`data`:true-是,false-否]")
    @GetMapping("check/depth")
    public ResponseDto<Boolean> isMember(@NotBlank @RequestParam String uid) {
        AdamUserMemberVo userMemberInfo = adamRdmService.getUserMemberVoByUid(uid);
        return ResponseDto.success(null != userMemberInfo && userMemberInfo.isActive());
    }
}
