package com.liquidnet.service.goblin.param;

import com.liquidnet.service.goblin.dto.manage.GoblinOrderSkuParam;
import com.liquidnet.service.goblin.entity.GoblinOrderAttr;
import com.liquidnet.service.goblin.entity.GoblinOrderSku;
import com.liquidnet.service.goblin.entity.GoblinStoreOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


@ApiModel(value = "GoblinOrderSqlParam")
@Data
public class GoblinOrderSqlParam implements Cloneable{

    private GoblinStoreOrder storeOrder;
    private GoblinOrderAttr orderAttr;
    private List<GoblinOrderSku> orderSkuList;
    private Map<String, GoblinOrderSkuParam> orderSkuParamMap;

    private static final GoblinOrderSqlParam obj = new GoblinOrderSqlParam();

    public static GoblinOrderSqlParam getNew() {
        try {
            return (GoblinOrderSqlParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinOrderSqlParam();
        }
    }
}
