package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinAcitveParam implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long mid;

    /**
     * 活动名称
     */
    @ApiModelProperty(value = "活动名称")
    private String activeName;

    /**
     * 券的数量
     */
    @ApiModelProperty(value = "券的数量")
    private Integer number;

    /**
     * activeId
     */
    @ApiModelProperty(value = "activeId")
    private String activeId;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    /**
     * 0未删除1已删除
     */
    @ApiModelProperty(value = "0未删除1已删除")
    private Integer delTag;

    /**
     * 演出id
     */
    @ApiModelProperty(value = "演出id")
    private String performanceId;


}
