package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.File;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 7.电子公函上传（使用nft平台签名）接口
 * @class: OfficialLetterUploadPlatformReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:25
 */
@Data
public class Nft007OfficialLetterUploadPlatformReqDto implements Serializable {
    /**
     * 电子公函图片，不超过5M，jpg或png格式
     */
    private File file;

    /**
     * 平台的"用户唯一标识"
     */
    private String platformIdentification;
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 平台签名信
     */
    private String platformSignData;
    private static final Nft007OfficialLetterUploadPlatformReqDto obj = new Nft007OfficialLetterUploadPlatformReqDto();
    private static final long serialVersionUID = -1302164034298735254L;

    public static Nft007OfficialLetterUploadPlatformReqDto getNew() {
        try {
            return (Nft007OfficialLetterUploadPlatformReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft007OfficialLetterUploadPlatformReqDto();
        }
    }
}
