package com.liquidnet.service.dragon.channel.alipay.strategy.impl;

import com.liquidnet.service.dragon.channel.alipay.biz.AlipayBiz;
import com.liquidnet.service.dragon.channel.alipay.req.AlipayTradePayReq;
import com.liquidnet.service.dragon.channel.alipay.strategy.annotation.StrategyAlipayHandler;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 支付宝小程序
 * @author zjp
 * @param null 
 * @return: null
 * @date 2024/4/26 13:29
*/
@Slf4j
@Component
@StrategyAlipayHandler(DragonConstant.DeviceFromEnum.APPLET)
public class AlipayStrategyAppletImpl extends AbstractAlipayStrategy {

    @Value("${liquidnet.dragon.url}")
    private String notifyUrl;

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Autowired
    private AlipayBiz alipayBiz;

    @Override
    protected Map<String, Object> executePay(AlipayTradePayReq alipayTradePayReq) {
        return alipayBiz.tradeAppletPay(alipayTradePayReq);
    }

    protected void setProductCode() {
        this.productCode = "JSAPI_PAY";
    }

    @Override
    protected String getNotifyUrl() {
        return notifyUrl + "/notify/alipay/applet";
    }

    @Override
    DragonPayBaseRespDto buildResponseDto(DragonPayBaseRespDto payBaseRespDto, Map<String, Object> respResult) {
        payBaseRespDto.getPayData().setTradeNo(respResult.get("tradeNo")!=null?respResult.get("tradeNo").toString():"");
        return payBaseRespDto;
    }
}
