package com.liquidnet.service.slime.service.impl;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.UserPathDto;
import com.liquidnet.service.kylin.dto.param.CreateTicketTimesParam;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketPartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketTimesPartnerVo;
import com.liquidnet.service.kylin.service.partner.IKylinTicketTimesPartnerService;
import com.liquidnet.service.slime.util.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * <p>
 * 场次 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
@Service
@Slf4j
public class KylinTicketTimesPartnerServiceImpl implements IKylinTicketTimesPartnerService {

    @Autowired
    RedisSlimeUtils redisSlimeUtils;
    @Autowired
    MongoSlimeUtils mongoSlimeUtils;
    @Autowired
    PerformanceUtils performanceUtils;
    @Autowired
    QueueUtil queueUtil;

    @Override
    public ResponseDto<KylinTicketTimesPartnerVo> createTimesSummary(CreateTicketTimesParam createTicketTimesParam) {
        ResponseDto<KylinTicketTimesPartnerVo> ticketTimesPartnerVo;
        //获取演出状态
        KylinPerformanceVo vo = mongoSlimeUtils.getPerformanceVoNoMerchant(createTicketTimesParam.getPerformancesId());
        if (null == vo) {
            ticketTimesPartnerVo = createTimes(createTicketTimesParam);
            log.info(UserPathDto.setPartnerData("0", "createTimes", createTicketTimesParam, ticketTimesPartnerVo));
        } else if (vo.getAuditStatus() == 0) {
            return ResponseDto.failure(ErrorMapping.get(20101));
        } else if (vo.getAppStatus() >= 3 && vo.getAppStatus() != 4) {//未被拒绝 且 通过审核的演出
            ticketTimesPartnerVo = addNewTimes(createTicketTimesParam);
            log.info(UserPathDto.setPartnerData("0", "addNewTimes", createTicketTimesParam, ticketTimesPartnerVo));
        } else {
            ticketTimesPartnerVo = createTimes(createTicketTimesParam);
            log.info(UserPathDto.setPartnerData("0", "createTimes", createTicketTimesParam, ticketTimesPartnerVo));
        }
        return ticketTimesPartnerVo;
    }

    @Override
    public ResponseDto<KylinTicketTimesPartnerVo> createTimes(CreateTicketTimesParam createTicketTimesParam) {
        try {
            // 获取 主键id
            String ticketTimesId = IDGenerator.nextSnowId();
            // 获取 当前时间 -> 创建时间
            LocalDateTime createdAt = LocalDateTime.now();
            // 标题
            String title = "";
            String useStart;
            String useEnd;
            if (createTicketTimesParam.getType() == 1) {
                useStart = createTicketTimesParam.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                useEnd = createTicketTimesParam.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                title = useStart;
            } else {
                useStart = createTicketTimesParam.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                useEnd = createTicketTimesParam.getUseEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
                title = useStart + "-" + useEnd;
            }
            // mongo 操作
            KylinTicketTimesPartnerVo kylinTicketTimesPartnerVo = KylinTicketTimesPartnerVo.getNew();
            kylinTicketTimesPartnerVo.setTicketTimesId(ticketTimesId);
            kylinTicketTimesPartnerVo.setUseStart(createTicketTimesParam.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            if (createTicketTimesParam.getType() == 2) {
                kylinTicketTimesPartnerVo.setUseEnd(createTicketTimesParam.getUseEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            } else {
                kylinTicketTimesPartnerVo.setUseEnd(createTicketTimesParam.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            }
            kylinTicketTimesPartnerVo.setStatus(1);
            kylinTicketTimesPartnerVo.setTitle(title);
            kylinTicketTimesPartnerVo.setPerformancesId(createTicketTimesParam.getPerformancesId());
            kylinTicketTimesPartnerVo.setType(createTicketTimesParam.getType());
            kylinTicketTimesPartnerVo.setRealNameLimit(createTicketTimesParam.getRealNameLimit());
            kylinTicketTimesPartnerVo.setCreatedAt(createdAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            mongoSlimeUtils.insertTicketTimesPartnerVo(kylinTicketTimesPartnerVo);
            return ResponseDto.success(kylinTicketTimesPartnerVo);
        } catch (Exception e) {
            log.info(UserPathDto.setPartnerData("0", "createTimes", createTicketTimesParam, e));
            return ResponseDto.failure(ErrorMapping.get(20105));
        }
    }

    @Override
    public ResponseDto<KylinTicketTimesPartnerVo> addNewTimes(CreateTicketTimesParam createTicketTimesParam) {
        try {
            // 获取 主键id
            String ticketTimesId = IDGenerator.nextSnowId();
            // 获取 当前时间 -> 创建时间
            LocalDateTime createdAt = LocalDateTime.now();
            // 标题
            String title = "";
            String useStart = createTicketTimesParam.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
            String useEnd = createTicketTimesParam.getUseEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
            if (createTicketTimesParam.getType() == 1) {
                if (!useStart.split(" ")[0].equals(useEnd.split(" ")[0])) {
                    return ResponseDto.failure(ErrorMapping.get(20118));
                }
                title = useStart;
            } else {
                title = useStart + "-" + useEnd;
            }

            // mongo 操作
            KylinTicketTimesPartnerVo kylinTicketTimesPartnerVo = KylinTicketTimesPartnerVo.getNew();
            kylinTicketTimesPartnerVo.setTicketTimesId(ticketTimesId);
            kylinTicketTimesPartnerVo.setUseStart(createTicketTimesParam.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            kylinTicketTimesPartnerVo.setUseEnd(createTicketTimesParam.getUseEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            kylinTicketTimesPartnerVo.setStatus(-1);
            kylinTicketTimesPartnerVo.setTitle(title);
            kylinTicketTimesPartnerVo.setPerformancesId(createTicketTimesParam.getPerformancesId());
            kylinTicketTimesPartnerVo.setType(createTicketTimesParam.getType());
            kylinTicketTimesPartnerVo.setRealNameLimit(createTicketTimesParam.getRealNameLimit());
            kylinTicketTimesPartnerVo.setCreatedAt(createdAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            mongoSlimeUtils.insertTicketTimesPartnerVo(kylinTicketTimesPartnerVo);
            return ResponseDto.success(kylinTicketTimesPartnerVo);
        } catch (Exception e) {
            log.info(UserPathDto.setPartnerData("0", "addNewTimes", createTicketTimesParam, e));
            return ResponseDto.failure(ErrorMapping.get(20101));
        }
    }

    @Override
    public ResponseDto<String> deleteTimes(String ticketTimesId, String performanceId) {
        try {
            LocalDateTime updatedAt = LocalDateTime.now();
            KylinTicketTimesPartnerVo data = mongoSlimeUtils.getTicketTimesPartnerVo(ticketTimesId);
            if (data.getStatus() == 0) {
                return ResponseDto.failure(ErrorMapping.get(20106));
            }
            KylinPerformanceVo vo = redisSlimeUtils.getPerformanceVo(performanceId);
            KylinTicketTimesVo ticketTimesData = null;
            if (vo == null) {
                mongoSlimeUtils.delTicketTimesPartnerVo(ticketTimesId);
                return ResponseDto.success("删除成功");
            } else {
                for (int x = 0; x < vo.getTicketTimeList().size(); x++) {
                    ticketTimesData = vo.getTicketTimeList().get(x);
                    if (ticketTimesData.getTimeId().equals(ticketTimesId)) {
                        break;
                    }
                }
                if (ticketTimesData != null) {
                    if (vo.getAuditStatus() == 0) {
                        return ResponseDto.failure(ErrorMapping.get(20101));
                    }
                    if (vo.getAppStatus() == 0 || vo.getAppStatus() == 4) {//未提审||被拒绝
                        KylinTicketTimesPartnerVo ticketTimesPartnerVo = KylinTicketTimesPartnerVo.getNew();
                        ticketTimesPartnerVo.setTicketTimesId(ticketTimesId);
                        ticketTimesPartnerVo.setUpdatedAt(updatedAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                        ticketTimesPartnerVo.setStatus(0);
                        mongoSlimeUtils.insertTicketTimesPartnerVo(ticketTimesPartnerVo);
                        log.info(UserPathDto.setPartnerData("0", "deleteTimes", "ticketTimesId=" + ticketTimesId, "删除成功"));
                        return ResponseDto.success("删除成功");
                    } else {
                        return ResponseDto.failure(ErrorMapping.get(20106));
                    }
                } else {
                    mongoSlimeUtils.delTicketTimesPartnerVo(ticketTimesId);
                    return ResponseDto.success();
                }
            }

        } catch (Exception e) {
            log.info(UserPathDto.setPartnerData("0", "deleteTimes", "ticketTimesId=" + ticketTimesId, e));
            return ResponseDto.failure(ErrorMapping.get(20102));
        }
    }

    @Override
    public ResponseDto<KylinTicketTimesPartnerVo> changeTimes(CreateTicketTimesParam createTicketTimesParam) {
        try {
            LocalDateTime updatedAt = LocalDateTime.now();
            String title = "";
            if (createTicketTimesParam.getType() == 1) {
                title = createTicketTimesParam.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
            } else {
                title = createTicketTimesParam.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")) + "-" + createTicketTimesParam.getUseEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
            }
            createTicketTimesParam.setTitle(title);
            // mongo 操作
            KylinTicketTimesPartnerVo kylinTicketTimesPartnerVo = KylinTicketTimesPartnerVo.getNew();
            BeanUtils.copyProperties(createTicketTimesParam, kylinTicketTimesPartnerVo);
            kylinTicketTimesPartnerVo.setTicketTimesId(createTicketTimesParam.getTicketTimesId());
            kylinTicketTimesPartnerVo.setTicketTimesId(createTicketTimesParam.getTicketTimesId());
            kylinTicketTimesPartnerVo.setUpdatedAt(updatedAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            kylinTicketTimesPartnerVo.setUseStart(createTicketTimesParam.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            kylinTicketTimesPartnerVo.setUseEnd(createTicketTimesParam.getUseEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            kylinTicketTimesPartnerVo.setStatus(null);
            mongoSlimeUtils.updateTicketTimesPartnerVo(kylinTicketTimesPartnerVo);
            KylinTicketPartnerVo ticketPartnerVo = KylinTicketPartnerVo.getNew();
            ticketPartnerVo.setTimesId(createTicketTimesParam.getTicketTimesId());
            ticketPartnerVo.setUseEnd(kylinTicketTimesPartnerVo.getUseEnd());
            ticketPartnerVo.setUseStart(kylinTicketTimesPartnerVo.getUseStart());
            mongoSlimeUtils.updateTicketPartnerVoByTimes(ticketPartnerVo);
            log.info(UserPathDto.setPartnerData("0", "changeTimes", createTicketTimesParam, "SUCCESS"));
            //JsonUtils.fromJson(doc.toJson(), KylinTicketTimesPartnerVo.class)
            return ResponseDto.success(null);
        } catch (Exception e) {
            e.printStackTrace();
            log.info(UserPathDto.setPartnerData("0", "changeTimes", createTicketTimesParam, e));
            return ResponseDto.failure(ErrorMapping.get(20103));
        }
    }

    @Override
    public List<KylinTicketTimesPartnerVo> getTimesMongoList(String performancesId) {
        return mongoSlimeUtils.getTimesMongoList(performancesId);
    }

    @Override
    public KylinTicketTimesPartnerVo getTimesMongo(String timesId) {
        return mongoSlimeUtils.getTimesMongo(timesId);
    }
}
