package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.vo.admin.SweetIntegralActivityPrizeVo;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityDraw;
import com.liquidnet.service.sweet.service.ISweetIntegralActivityDrawService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 积分活动抽奖记录表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-26
 */
@Api(tags = "活动-积分抽奖")
@RestController
@RequestMapping("/integralActivityDraw")
public class SweetIntegralActivityDrawController {
    @Autowired
    private ISweetIntegralActivityDrawService activityDrawService;

    @PostMapping("create")
    @ApiOperation("用户抽奖")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "integralActivityId", value = "活动id", required = true)
    })
    public ResponseDto<SweetIntegralActivityPrizeVo> create(
            @RequestParam("integralActivityId") String integralActivityId
    ) {
        return activityDrawService.create(integralActivityId);
    }

    @GetMapping("winPrize")
    @ApiOperation("用户(中奖、抽奖)记录列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1中奖记录 2抽奖记录", required = true)
    })
    public ResponseDto<List<SweetIntegralActivityDraw>> winPrize(
            @RequestParam("type") Integer type
    ) {
        return activityDrawService.winPrize(type);
    }

    @GetMapping("winPrizeUser")
    @ApiOperation("活动中奖用户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "integralActivityId", value = "活动id", required = true)
    })
    public ResponseDto<List<SweetIntegralActivityDraw>> winPrizeUser(
            @RequestParam("integralActivityId") String integralActivityId
    ) {
        return activityDrawService.winPrizeUser(integralActivityId);
    }

    @PostMapping("perfectAddress")
    @ApiOperation("中奖完善收货地址")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "drawId", value = "中奖ID", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "receivingAddressesId", value = "adam收货地址addresses_id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "receivingName", value = "adam收货人姓名", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "receivingPhone", value = "adam收货人手机号", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "receivingAddress", value = "adam收货人完整地址 空格隔离省市区详细地址", required = true)
    })
    public ResponseDto perfectAddress(
            @RequestParam("drawId") String drawId,
            @RequestParam("receivingAddressesId") String receivingAddressesId,
            @RequestParam("receivingName") String receivingName,
            @RequestParam("receivingPhone") String receivingPhone,
            @RequestParam("receivingAddress") String receivingAddress
    ) {
        return activityDrawService.perfectAddress(drawId, receivingAddressesId, receivingName, receivingPhone, receivingAddress);
    }

}
