package com.liquidnet.service.dragon.channel.wepay.strategy;

import com.liquidnet.service.dragon.channel.wepay.strategy.annotation.StrategyWepayHandler;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.Map;


/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: Test
 * @Package com.liquidnet.service.dragon.channel.strategy
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 14:27
 */
@Component
public class WepayStrategyListener implements ApplicationListener<ContextRefreshedEvent> {

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map<String, Object> beans = event.getApplicationContext().getBeansWithAnnotation(StrategyWepayHandler.class);
        WepayStrategyContext strategyContext = event.getApplicationContext().getBean(WepayStrategyContext.class);
        beans.forEach((name, bean) -> {
            StrategyWepayHandler typeHandler = bean.getClass().getAnnotation(StrategyWepayHandler.class);
            strategyContext.putStrategy(typeHandler.value().getCode(), (IWepayStrategy) bean);
        });
    }
}