package com.liquidnet.service.sweet.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 失物招领管理员查询参数
 *
 * @author liquidnet
 * @since 2025-01-18
 */
@Data
@ApiModel("失物招领管理员查询参数")
public class SweetLostFoundAdminParam implements Serializable {

    @ApiModelProperty("主键ID 编辑填写")
    @NotNull(message = "ID不能为空", groups = ValidationGroups.Update.class)
    private Long id;

    @ApiModelProperty("手机号")
    @NotBlank(message = "手机号不能为空")
    private String phone;

    @ApiModelProperty("备注姓名")
    private String name;

    @ApiModelProperty("权限类型：1-发帖员(仅发帖,发布后不可编辑) 2-管理员(发帖、编辑、删除)")
    @NotNull(message = "权限类型不能为空")
    private Integer permissionType;

    @ApiModelProperty("授权范围：1-本站次 2-全站")
    @NotNull(message = "授权范围不能为空")
    private Integer authScope;

    @ApiModelProperty("演出ID")
    @NotBlank(message = "演出ID不能为空")
    private String performanceId;

}