package com.liquidnet.service.consumer.base.receiver;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftTransferReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftTransferRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.stereotype.Component;

import java.util.HashMap;

@Slf4j
@Component
public class ConsumerGalaxyJsonNftTransferReceiver extends AbstractBizRedisReceiver {
    @Value("${liquidnet.service.goblin.url}")
    private String serviceGoblinUrl;

    @Override
    protected boolean consumerMessageHandler(String msg) {
        boolean aBoolean = false;
        try {
            GalaxyNftTransferReqDto textMessage = JsonUtils.fromJson(msg, GalaxyNftTransferReqDto.class);
            if (textMessage == null) {
                aBoolean = true;
            } else {
                //执行计数
                ResponseDto<GalaxyNftTransferRespDto> responseDto = this.nftTransfer(textMessage);
                if(responseDto.isSuccess()){
                    aBoolean = true;
                }
            }
        } catch (Exception e) {
            log.error("CONSUMER MSG EX_HANDLE ==> [{}]:{}", this.getRedisStreamKey(), msg, e);
        } finally {
            if (!aBoolean) {
                HashMap<String, String> map = CollectionUtil.mapStringString();
                map.put("message", msg);
                stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(this.getRedisStreamKey()));
            }
        }
        return aBoolean;
    }

    @Override
    protected String getRedisStreamKey() {
        return MQConst.GalaxyQueue.JSON_NFT_TRANSFER.getKey();
    }

    @Override
    protected String getRedisStreamGroup() {
        return MQConst.GalaxyQueue.JSON_NFT_TRANSFER.getGroup();
    }

    /**
     * 执行nft转让
     * @param reqDto
     * @return
     */
    private ResponseDto<GalaxyNftTransferRespDto> nftTransfer(GalaxyNftTransferReqDto reqDto) {
        String postUrl = serviceGoblinUrl + "/goblin/nftTrade/que/nftTransfer";
        try {
            String postRespStr = HttpUtil.postJson(postUrl, JsonUtils.toJson(reqDto));
            ResponseDto responseDto = JsonUtils.fromJson(postRespStr, ResponseDto.class);
            return  responseDto;
        } catch (Exception e) {
            log.error("Ex.NFT转让:请求异常[url={},paramsStr={}],ex:{}", postUrl, JsonUtils.toJson(reqDto), e.getMessage());
            return ResponseDto.failure();
        }
    }
}
