package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityPrizeVo;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityVo;
import com.liquidnet.service.sweet.entity.SweetIntegralActivity;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityDraw;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityDrawMapper;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityMapper;
import com.liquidnet.service.sweet.service.ISweetIntegralActivityService;
import com.liquidnet.service.sweet.utils.ObjectUtil;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;

/**
 * <p>
 * 积分活动表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-25
 */
@Service
public class SweetIntegralActivityServiceImpl extends ServiceImpl<SweetIntegralActivityMapper, SweetIntegralActivity> implements ISweetIntegralActivityService {

    @Autowired
    private RedisDataUtils redisDataUtils;

    @Autowired
    private SweetIntegralActivityDrawMapper drawMapper;

    @Override
    public ResponseDto<List<IntegralActivityVo>> getList() {
        List<IntegralActivityVo> integralActivityList = redisDataUtils.getIntegralActivityList();
        ArrayList<IntegralActivityVo> sweetIntegralActivityVoList = ObjectUtil.getSweetIntegralActivityVoList();
        for (IntegralActivityVo info : integralActivityList) {
            if (info.getIsOnline() == 1) {
                continue;
            }
            if (info.getTimeType() == 2) {
                LocalDateTime startTime = info.getStartTime();
                LocalDateTime endTime = info.getEndTime();
                LocalDateTime nowTime = LocalDateTime.now();
                if (nowTime.isAfter(endTime)) { // 已结束
                    continue;
                }
                if (startTime.isAfter(nowTime)) { // 未开始
                    continue;
                }
            }

            sweetIntegralActivityVoList.add(info);
        }
        return ResponseDto.success(sweetIntegralActivityVoList);
    }

    @Override
    public ResponseDto<IntegralActivityVo> detail(String integralActivityId) {
        IntegralActivityVo integralActivity = redisDataUtils.getIntegralActivityInfo(integralActivityId);
        integralActivity.setPrizeList1(null);
        integralActivity.setPrizeList2(null);
        List<IntegralActivityPrizeVo> prizeList = integralActivity.getPrizeList();
        if (!CollectionUtils.isEmpty(prizeList)) {
            prizeList.forEach(r -> {
                r.setPrizeNum(null);
                r.setWinningProbability(null);
                r.setPrizeRelationList(null);
                r.setCreatedAt(null);
                r.setUpdatedAt(null);
            });
        }
        return ResponseDto.success(integralActivity);
    }

    @Override
    public ResponseDto setDrawAllList(String integralActivityId) {
        List<SweetIntegralActivityDraw> sweetIntegralActivityDraws = drawMapper.selectList(
                Wrappers.lambdaQuery(SweetIntegralActivityDraw.class).eq(SweetIntegralActivityDraw::getIntegralActivityId, integralActivityId)
                        .last("limit 0,35")
        );

        List<String> asList = Arrays.asList(
                "冯", "陈", "褚", "卫",
                "蒋", "沈", "韩", "杨",
                "朱", "秦", "尤", "许",
                "何", "吕", "施", "张",
                "孔", "曹", "严", "华",
                "金", "魏", "陶", "姜",
                "戚", "谢", "邹", "喻",
                "柏", "水", "窦", "章",
                "云", "苏", "潘", "葛",
                "奚", "范", "彭", "郎",
                "鲁", "韦", "昌", "马",
                "苗", "凤", "花", "方",
                "俞", "任", "袁", "柳",
                "酆", "鲍", "史", "唐",
                "费", "廉", "岑", "薛",
                "雷", "贺", "倪", "汤"
        );
        ArrayList<String> asListArr = new ArrayList(asList);

        IntegralActivityVo integralActivityInfo = redisDataUtils.getIntegralActivityInfo(integralActivityId);
        List<IntegralActivityPrizeVo> prizeList2 = integralActivityInfo.getPrizeList2();

        Random random = new Random();
        for (int i = 0; i < 5; i++) {
            String name = asListArr.get(random.nextInt(asListArr.size()));
            IntegralActivityPrizeVo activityPrizeVo = prizeList2.get(random.nextInt(prizeList2.size()));
            SweetIntegralActivityDraw activityDraw = SweetIntegralActivityDraw.getNew();
            activityDraw.setNickname(name);
            activityDraw.setPrizeTitle(activityPrizeVo.getPrizeTitle());
            sweetIntegralActivityDraws.add(activityDraw);
        }

        Collections.shuffle(sweetIntegralActivityDraws);
        redisDataUtils.setIntegralActivityDrawAll(integralActivityId, sweetIntegralActivityDraws);

        return ResponseDto.success();
    }

    @Override
    public ResponseDto drawBlack(String uidS) {
        String[] strings = uidS.split(",");
        List<String> aList = Arrays.asList(strings);
        redisDataUtils.setIntegralActivityDrawBlack(aList);
//        boolean contains = aList.contains("11");
        return ResponseDto.success();
    }
}
