package com.liquidnet.client.admin.web.controller.zhengzai.adam;

import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.adam.domain.AdamUser;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamUserService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 用户Controller
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/adam/user")
public class AdamUserController extends BaseController
{
    private String prefix = "adam/user";

    @Autowired
    private IAdamUserService adamUserService;

    @RequiresPermissions("adam:user:view")
    @GetMapping()
    public String user()
    {
        return prefix + "/user";
    }

    /**
     * 查询用户列表
     */
    @RequiresPermissions("adam:user:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(AdamUser adamUser)
    {
        startPage();
        List<AdamUser> list = adamUserService.selectAdamUserList(adamUser);
        return getDataTable(list);
    }

    /**
     * 导出用户列表
     */
    @RequiresPermissions("adam:user:export")
    @Log(title = "用户", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    @ResponseBody
    public AjaxResult export(AdamUser adamUser)
    {
        List<AdamUser> list = adamUserService.selectAdamUserList(adamUser);
        ExcelUtil<AdamUser> util = new ExcelUtil<AdamUser>(AdamUser.class);
        return util.exportExcel(list, "用户数据");
    }

    /**
     * 新增用户
     */
    @GetMapping("/add")
    public String add()
    {
        return prefix + "/add";
    }

    /**
     * 新增保存用户
     */
    @RequiresPermissions("adam:user:add")
    @Log(title = "用户", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    @ResponseBody
    public AjaxResult addSave(AdamUser adamUser)
    {
        return toAjax(adamUserService.insertAdamUser(adamUser));
    }

    /**
     * 修改用户
     */
    @GetMapping("/edit/{mid}")
    public String edit(@PathVariable("mid") Integer mid, ModelMap mmap)
    {
        AdamUser adamUser = adamUserService.selectAdamUserById(mid);
        mmap.put("adamUser", adamUser);
        return prefix + "/edit";
    }

    /**
     * 修改保存用户
     */
    @RequiresPermissions("adam:user:edit")
    @Log(title = "用户", businessType = BusinessType.UPDATE)
    @PostMapping("/edit")
    @ResponseBody
    public AjaxResult editSave(AdamUser adamUser)
    {
        return toAjax(adamUserService.updateAdamUser(adamUser));
    }

    /**
     * 删除用户
     */
    @RequiresPermissions("adam:user:remove")
    @Log(title = "用户", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    @ResponseBody
    public AjaxResult remove(String ids)
    {
        return toAjax(adamUserService.deleteAdamUserByIds(ids));
    }
}
