package com.liquidnet.service.merchant.dto.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(value = "MerchantSponsorEditParam", description = "编辑主办入参")
@Data
public class MerchantSponsorEditParam implements java.io.Serializable {
    private static final long serialVersionUID = -2088609830098635915L;

    @ApiModelProperty(position = 10, required = true, value = "主办ID")
    @NotBlank(message = "主办ID不能为空")
    private String sponsorId;

    @ApiModelProperty(position = 11, required = true, value = "主办名称[30]", example = "测试")
    @Size(max = 30, message = "主办名称长度限制1-30位")
    @NotBlank(message = "名称不能为空")
    private String name;
    @ApiModelProperty(position = 12, required = true, value = "logo图", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    @NotBlank(message = "logo图不能为空")
    private String logo;
    @ApiModelProperty(position = 13, required = true, value = "背景图", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    @NotBlank(message = "背景图不能为空")
    private String background;
    @ApiModelProperty(position = 14, required = true, value = "介绍[1000]", example = "这是一段介绍文字")
    private String description;

    @ApiModelProperty(position = 19, required = true, value = "联系人邮箱", example = "zhangsan@zhengzai.tv")
    @NotNull
    private String contactEmail;
}
