package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.zhengzai.kylin.service.IToolService;
import com.liquidnet.client.admin.zhengzai.kylin.utils.DataUtils;
import com.liquidnet.client.admin.zhengzai.kylin.utils.MongoVoUtils;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.DateUtil;

import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;

import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.entity.KylinOrderTicketEntities;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketEntitiesMapper;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketVoMapper;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketsMapper;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Service
@Slf4j
public class ToolServiceImpl implements IToolService {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private KylinOrderTicketEntitiesMapper kylinOrderTicketEntitiesMapper;
    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;
    @Autowired
    private KylinOrderTicketVoMapper kylinOrderTicketVoMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;
    @Autowired
    private MongoVoUtils mongoVoUtils;

    @Override
    public Boolean supplementEnter(String orderTicketEntitiesId, String enterName, String enterMobile, String enterIdCode, Integer enterType, String orderId) {
        mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderTicketEntitiesId").is(orderTicketEntitiesId)).getQueryObject(),
                new Document("$set", new Document("enterType", enterType)
                        .append("enterName", enterName)
                        .append("enterMobile", enterMobile)
                        .append("enterIdCode", enterIdCode)
                        .append("updatedAt", DateUtil.Formatter.yyyyMMddHHmmss.format(LocalDateTime.now())))
        );

        KylinOrderTicketEntities orderTicketEntities = KylinOrderTicketEntities.getNew();
        orderTicketEntities.setEnterType(enterType);
        orderTicketEntities.setEnterName(enterName);
        orderTicketEntities.setEnterMobile(enterMobile);
        orderTicketEntities.setEnterIdCode(enterIdCode);
        orderTicketEntities.setUpdatedAt(LocalDateTime.now());
        kylinOrderTicketEntitiesMapper.update(orderTicketEntities, Wrappers.lambdaUpdate(KylinOrderTicketEntities.class).eq(KylinOrderTicketEntities::getOrderTicketEntitiesId, orderTicketEntitiesId));

        dataUtils.delOrderTicketRedis(orderId);
        return true;
    }

    @Override
    public KylinOrderTicketEntities getSingleEnter(String orderTicketEntitiesId) {
        KylinOrderTicketEntities entitiesList = kylinOrderTicketEntitiesMapper.selectOne(Wrappers.lambdaUpdate(KylinOrderTicketEntities.class).eq(KylinOrderTicketEntities::getOrderTicketEntitiesId, orderTicketEntitiesId));
        return entitiesList;
    }

    @Override
    public List<KylinOrderTicketEntities> getOrderTicketEnterByOrderCode(String orderCode) {
        KylinOrderTickets orderTickets = kylinOrderTicketsMapper.selectOne(Wrappers.lambdaUpdate(KylinOrderTickets.class).eq(KylinOrderTickets::getOrderCode, orderCode));
        if (orderTickets == null) {
            return null;
        }
        String orderId = orderTickets.getOrderTicketsId();
        List<KylinOrderTicketEntities> entitiesList = kylinOrderTicketEntitiesMapper.selectList(Wrappers.lambdaUpdate(KylinOrderTicketEntities.class).eq(KylinOrderTicketEntities::getOrderId, orderId));
        return entitiesList;
    }

    @Override
    public List<KylinOrderTickets> getExpressContactsByOrderCode(String orderCode) {

        List<KylinOrderTickets> KylinOrderTickets = kylinOrderTicketVoMapper.getExpressContactsByOrderCode(orderCode);
        return KylinOrderTickets;
    }


    @Override
    public  Integer updOrderExpressPhoneByOrderCode(String orderCode, String expressPhone) {
        int upd = kylinOrderTicketVoMapper.updOrderExpressPhoneByOrderCode(orderCode, expressPhone);
        //存mongo
        mongoVoUtils.orderSetMongo(orderCode, expressPhone);
        //存redis
       dataUtils.orderSetRedis(orderCode);
       Object o = redisDataSourceUtil.getRedisKylinUtil().get("kylin:order:id:201373316981841927358500");
        return upd;
    }
}
