/*
 Navicat Premium Data Transfer

 Source Server         : mysql-test
 Source Server Type    : MySQL
 Source Server Version : 50732
 Source Host           : 192.168.31.205:3306
 Source Schema         : liquidnet_adam

 Target Server Type    : MySQL
 Target Server Version : 50732
 File Encoding         : 65001

 Date: 17/12/2020 15:42:47
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

drop schema if exists liquidnet_adam;
create database liquidnet_adam character set utf8mb4 collate utf8mb4_unicode_ci;

use `liquidnet_adam`;
-- ----------------------------
-- Table structure for adam_account
-- ----------------------------
DROP TABLE IF EXISTS `adam_account`;
CREATE TABLE `adam_account` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '公司id',
  `state` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '状态',
  `fin_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '资金账户id',
  `bank_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '银行账户id',
  `bank_channel` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '银行标识',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='公司账户';

-- ----------------------------
-- Table structure for adam_account_wallet
-- ----------------------------
DROP TABLE IF EXISTS `adam_account_wallet`;
CREATE TABLE `adam_account_wallet` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键id',
  `fin_wallet_no` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '资金钱包no',
  `account_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '账户id',
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'com id',
  `currency` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '币种',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '钱包名称',
  `state` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '状态,1预创建，2正常，3删除',
  `bank_wallet_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '银行钱包id',
  `bank_channel` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '银行标识',
  `delete_date` timestamp NULL DEFAULT NULL COMMENT '删除时间',
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='账户钱包';

-- ----------------------------
-- Table structure for adam_adminis_process_his
-- ----------------------------
DROP TABLE IF EXISTS `adam_adminis_process_his`;
CREATE TABLE `adam_adminis_process_his` (
  `his_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'edited user id',
  `his_tag` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'my_profile,user_administration,wallet_access_administration',
  `his_val` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'updated basic profile,changed password,requested change email,created,updated,removed',
  `his_snap` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operator` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operat_time` datetime DEFAULT NULL,
  `operator_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`his_id`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for adam_bank_cc_account
-- ----------------------------
DROP TABLE IF EXISTS `adam_bank_cc_account`;
CREATE TABLE `adam_bank_cc_account` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'com id',
  `bank_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'bank id',
  `contact_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'contact_id',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='cc account';

-- ----------------------------
-- Table structure for adam_beneficiary
-- ----------------------------
DROP TABLE IF EXISTS `adam_beneficiary`;
CREATE TABLE `adam_beneficiary` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '公司id',
  `legal_entity_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '类型',
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '状态',
  `currency` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nick_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `full_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `post_code` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `province` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_country` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_no` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method_detail` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delete_time` timestamp NULL DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `adam_payment_beneficiary_id_uindex` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='收款人';

-- ----------------------------
-- Table structure for adam_com_info
-- ----------------------------
DROP TABLE IF EXISTS `adam_com_info`;
CREATE TABLE `adam_com_info` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键id',
  `name` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '公司名称',
  `state` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '状态',
  `type` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '类型',
  `type_other` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '类型-其他',
  `stake_number` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'The number of individuals or companies with at least a 25% stake in the company',
  `registration_country_code` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '注册国家代码',
  `registration_number` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '注册号',
  `website_url` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '网址',
  `entity_structure` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '实体结构',
  `business_years` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '营业年限',
  `industry_category` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '行业类别',
  `industry_category_other` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '行业类别-其他',
  `phone_code` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '电话代码',
  `phone_number` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '电话号码',
  `address_country` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '国家',
  `address_province` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '州/省',
  `address_city` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '城市',
  `address_street` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '街道',
  `address_post_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '邮编',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='公司信息';

-- ----------------------------
-- Table structure for adam_com_info_extend
-- ----------------------------
DROP TABLE IF EXISTS `adam_com_info_extend`;
CREATE TABLE `adam_com_info_extend` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键id',
  `files` longtext COLLATE utf8mb4_unicode_ci COMMENT '文件json',
  `business_question` longtext COLLATE utf8mb4_unicode_ci COMMENT '业务用途json',
  `financial_question` longtext COLLATE utf8mb4_unicode_ci COMMENT '财务合规问卷json',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='公司信息扩展';

-- ----------------------------
-- Table structure for adam_com_legal_person
-- ----------------------------
DROP TABLE IF EXISTS `adam_com_legal_person`;
CREATE TABLE `adam_com_legal_person` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键id',
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `full_name` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '全名',
  `date_birth` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '出生日期',
  `phone_code` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '电话代码',
  `phone_number` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '电话号码',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '邮件地址',
  `id_country_code` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'id签发国家/地区代码',
  `id_type` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '类型',
  `id_number` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'id号',
  `id_proof` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'id文件证明',
  `address_country` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '国家',
  `address_province` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '州/省',
  `address_city` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '城市',
  `address_street` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '街道',
  `address_post_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '邮编',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  `address_proof` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '住宅文件证明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='公司法人';

-- ----------------------------
-- Table structure for adam_com_profile
-- ----------------------------
DROP TABLE IF EXISTS `adam_com_profile`;
CREATE TABLE `adam_com_profile` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_val` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_desc` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `adam_com_profile_com_id_item_uindex` (`com_id`,`item`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for adam_com_shareholder
-- ----------------------------
DROP TABLE IF EXISTS `adam_com_shareholder`;
CREATE TABLE `adam_com_shareholder` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键id',
  `com_id` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '公司id',
  `position` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '职位',
  `full_name` varchar(99) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '全名',
  `date_birth` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '出生日期',
  `id_country_code` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'id颁发国家代码',
  `residential_address` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '住宅地址',
  `id_proof` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'id文件证明',
  `address_proof` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '住宅文件证明',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='公司股东信息';

-- ----------------------------
-- Table structure for adam_company_profile
-- ----------------------------
DROP TABLE IF EXISTS `adam_company_profile`;
CREATE TABLE `adam_company_profile` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_val` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_desc` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for adam_conversion
-- ----------------------------
DROP TABLE IF EXISTS `adam_conversion`;
CREATE TABLE `adam_conversion` (
    `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
    `com_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `user_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `from_wallet_no` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `to_wallet_no` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `sell_amount` decimal(20,4) DEFAULT NULL,
    `sell_currency` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `buy_currency` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `buy_amount` decimal(20,4) DEFAULT NULL,
    `fixed_side` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `quote_rate` decimal(15,6) DEFAULT NULL,
    `execution_rate` decimal(15,6) DEFAULT NULL,
    `conversion_date` timestamp NULL DEFAULT NULL,
    `settlement_date` timestamp NULL DEFAULT NULL,
    `bank_channel` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `bank_conversion_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `failure_reason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
    `create_time` timestamp NULL DEFAULT NULL,
    `update_time` timestamp NULL DEFAULT NULL,
    `complete_time` timestamp NULL DEFAULT NULL,
    PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='订单换汇';

-- ----------------------------
-- Table structure for adam_country_file
-- ----------------------------
DROP TABLE IF EXISTS `adam_country_file`;
CREATE TABLE `adam_country_file` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键id',
  `file_code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '文件代码',
  `file_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '默认标题',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='注册国家文件';

-- ----------------------------
-- Table structure for adam_country_file_link
-- ----------------------------
DROP TABLE IF EXISTS `adam_country_file_link`;
CREATE TABLE `adam_country_file_link` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键ID',
  `country_code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '国家代码',
  `file_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '文件id',
  `file_alias_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '文件标题',
  `sort` int(5) DEFAULT NULL COMMENT '文件排序',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='注册国家关联文件表';

-- ----------------------------
-- Table structure for adam_funding
-- ----------------------------
DROP TABLE IF EXISTS `adam_funding`;
CREATE TABLE `adam_funding` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fin_wallet_no` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '状态',
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '币种',
  `amount` decimal(20,6) NOT NULL COMMENT '金额',
  `reference` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bank_funding_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '银行id',
  `bank_channel` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '银行渠道',
  `complete_time` timestamp NULL DEFAULT NULL COMMENT '完成时间',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `adam_transaction_record_id_uindex` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='订单充值';

-- ----------------------------
-- Table structure for adam_login_log
-- ----------------------------
DROP TABLE IF EXISTS `adam_login_log`;
CREATE TABLE `adam_login_log` (
  `id` bigint(50) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '用户id',
  `ipaddr` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '登录IP地址',
  `login_location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '登录地点',
  `browser` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '浏览器类型',
  `os` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '操作系统',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '登录状态（0成功 1失败）',
  `msg` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '提示消息',
  `login_time` datetime DEFAULT NULL COMMENT '访问时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1067 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统访问记录';

-- ----------------------------
-- Table structure for adam_login_online
-- ----------------------------
DROP TABLE IF EXISTS `adam_login_online`;
CREATE TABLE `adam_login_online` (
  `id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'id',
  `user_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '用户id',
  `session_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户会话id',
  `com_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '公司id',
  `account_no` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '账号',
  `telephone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '手机号',
  `ipaddr` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '登录IP地址',
  `login_location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '登录地点',
  `browser` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '浏览器类型',
  `os` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '操作系统',
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '在线状态on_line在线off_line离线',
  `start_timestamp` datetime DEFAULT NULL COMMENT 'session创建时间',
  `last_access_time` datetime DEFAULT NULL COMMENT 'session最后访问时间',
  `expire_time` int(5) DEFAULT '0' COMMENT '超时时间，单位为分钟',
  PRIMARY KEY (`session_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='在线用户记录';

-- ----------------------------
-- Table structure for adam_payer
-- ----------------------------
DROP TABLE IF EXISTS `adam_payer`;
CREATE TABLE `adam_payer` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `legal_entity_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `full_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `province` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delete_time` timestamp NULL DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `adam_payment_payer_id_uindex` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='付款人';

-- ----------------------------
-- Table structure for adam_payout
-- ----------------------------
DROP TABLE IF EXISTS `adam_payout`;
CREATE TABLE `adam_payout` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fin_wallet_no` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'fin wallet no',
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '币种',
  `amount` decimal(20,6) DEFAULT NULL COMMENT '金额',
  `reference` varchar(140) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '参考信息',
  `reason` varchar(105) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '原因目的',
  `bank_payout_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_channel` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `execution_date` date DEFAULT NULL COMMENT '执行日期',
  `fx_with` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fx_contract_no` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fx_quote` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `failure_reason` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '失败原因',
  `spot_forward` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '即期远期',
  `complete_time` timestamp NULL DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `adam_payment_id_uindex` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='订单下发';

-- ----------------------------
-- Table structure for adam_payout_beneficiary
-- ----------------------------
DROP TABLE IF EXISTS `adam_payout_beneficiary`;
CREATE TABLE `adam_payout_beneficiary` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `legal_entity_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `existing` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nick_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `full_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `post_code` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `province` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_country` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_no` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method_detail` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method_use` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `adam_payment_beneficiary_id_uindex` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='下发收款人';

-- ----------------------------
-- Table structure for adam_payout_payer
-- ----------------------------
DROP TABLE IF EXISTS `adam_payout_payer`;
CREATE TABLE `adam_payout_payer` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sender_default` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sender_existing` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `legal_entity_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `full_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `province` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `adam_payment_payer_id_uindex` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='下发付款人';

-- ----------------------------
-- Table structure for adam_role
-- ----------------------------
DROP TABLE IF EXISTS `adam_role`;
CREATE TABLE `adam_role` (
  `role_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `role_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role_sort` int(4) DEFAULT NULL,
  `role_status` char(1) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '1-normal,2-disable',
  `del_flag` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1' COMMENT '1-existed,2-deleted',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `remark` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for adam_role_permission
-- ----------------------------
DROP TABLE IF EXISTS `adam_role_permission`;
CREATE TABLE `adam_role_permission` (
  `role_id` bigint(20) unsigned NOT NULL,
  `auth_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `executable` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '0-non,1-true,2-false',
  `editable` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '2' COMMENT '1-true,2-false',
  PRIMARY KEY (`role_id`,`auth_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for adam_sys_country
-- ----------------------------
DROP TABLE IF EXISTS `adam_sys_country`;
CREATE TABLE `adam_sys_country` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '国家代码二位',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '名称',
  `phone_code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '电话代码',
  `currency_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '币种名称',
  `currency_alphabetic_code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '币种字母代码',
  `currency_numeric_code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '币种数字代码',
  `currency_minor_unit` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '币种精度',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家表';

-- ----------------------------
-- Table structure for adam_sys_country_province
-- ----------------------------
DROP TABLE IF EXISTS `adam_sys_country_province`;
CREATE TABLE `adam_sys_country_province` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `country_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '国家代码二位',
  `province_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '州省代码',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='国家州/省';

-- ----------------------------
-- Table structure for adam_transaction
-- ----------------------------
DROP TABLE IF EXISTS `adam_transaction`;
CREATE TABLE `adam_transaction` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `number` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '编号，可重复',
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '交易类型',
  `status` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '状态',
  `currency` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '币种',
  `fund_amount` decimal(20,6) NOT NULL COMMENT '金额',
  `fund_direction` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '出账/入账',
  `related_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '关联订单id',
  `related_reference` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '关联订单reference',
  `bank_transaction_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '银行交易id',
  `bank_channel` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '银行渠道',
  `fin_wallet_no` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '钱包账号',
  `fin_wallet_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '钱包名称',
  `fin_wallet_transaction_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '钱包交易id',
  `fin_wallet_available_balance` decimal(20,6) DEFAULT NULL COMMENT '钱包可用余额',
  `fin_wallet_total_balance` decimal(20,6) DEFAULT NULL COMMENT '钱包总余额',
  `failure_reason` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '失败原因',
  `complete_time` timestamp NULL DEFAULT NULL COMMENT '完成时间',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `adam_transaction_record_id_uindex` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='交易记录表';

-- ----------------------------
-- Table structure for adam_user
-- ----------------------------
DROP TABLE IF EXISTS `adam_user`;
CREATE TABLE `adam_user` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户id',
  `first_name` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '名',
  `last_name` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '姓',
  `job_title` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '职业',
  `email` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '邮箱',
  `password` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '密码加密后字符',
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '公司id',
  `status` varchar(11) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'user_status:0-Removed,1-Active,2-Invited',
  `phone_code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '电话代码',
  `phone_number` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '电话号码',
  `removed_time` datetime DEFAULT NULL COMMENT '移除时间',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '更新时间',
  `role` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '角色',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户信息';

-- ----------------------------
-- Table structure for adam_user_auth_log
-- ----------------------------
DROP TABLE IF EXISTS `adam_user_auth_log`;
CREATE TABLE `adam_user_auth_log` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'id',
  `user_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'user id',
  `auth_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '认证类型',
  `auth_result` enum('SUCCESS','FAILURE','PENDING') COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '认证结果 SUCCESS, FAILURE, PENDING',
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户认证记录';

-- ----------------------------
-- Table structure for adam_user_feedback
-- ----------------------------
DROP TABLE IF EXISTS `adam_user_feedback`;
CREATE TABLE `adam_user_feedback` (
  `id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `detail` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `files` longtext COLLATE utf8mb4_unicode_ci,
  `create_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户反馈';

-- ----------------------------
-- Table structure for adam_user_permission
-- ----------------------------
DROP TABLE IF EXISTS `adam_user_permission`;
CREATE TABLE `adam_user_permission` (
  `user_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `role_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `executable` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '0-non_executable,1-true,2-false',
  `editable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2' COMMENT '1-true,2-false',
  PRIMARY KEY (`user_id`,`com_id`,`auth_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for adam_wallet_access
-- ----------------------------
DROP TABLE IF EXISTS `adam_wallet_access`;
CREATE TABLE `adam_wallet_access` (
  `user_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fin_wallet_no` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `com_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`,`fin_wallet_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for sys_sequence
-- ----------------------------
DROP TABLE IF EXISTS `sys_sequence`;
CREATE TABLE `sys_sequence` (
  `seq_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `current_val` bigint(20) NOT NULL,
  `increment` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`seq_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


