package com.liquidnet.service.merchant.constant;

public class MerchantAuthorizationConst {

    // 某演出通过审核后，分配演出权限，场地方审核演出为'待审核的演出'与'演出'不同
    public enum PerformancePermission {
        READ("1", "查看详情"),
        EDIT("2", "编辑提交"),
        LINE("3", "上下线"),
        SALES("4", "销售统计"),
        CHECK("5", "验票"),
        GRANT("6", "授权"),
        AUDIT("7", "审核");

        private final String id;
        private final String name;

        PerformancePermission(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return id;
        }

        public String getName() {
            return name;
        }
    }

    public enum PerformanceRole {
        CREATOR("CREATOR", "创建者", 50),
        SPONSOR("SPONSOR", "主办方", 40),
        FIELDER("FIELDER", "场地方", 30),
        CHECKER("CHECKER", "验票员", 20),
        AUDITOR("AUDITOR", "审核员", 10);

        private final String role;
        private final String name;
        private final Integer level;

        PerformanceRole(String role, String name, Integer level) {
            this.role = role;
            this.name = name;
            this.level = level;
        }

        public String getRole() {
            return role;
        }

        public String getName() {
            return name;
        }

        public Integer getLevel() {
            return level;
        }
    }
}
