package com.liquidnet.service.platform.vo.ticketSystem;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel
public class TimesVo implements Serializable {
    private static final long serialVersionUID = 4073256621782131607L;
    @ApiModelProperty(value = "演出场次ID")
    private String sessionId;
    @ApiModelProperty(value = "场次名称")
    private String sessionName;
    @ApiModelProperty(value = "演出场所或场厅编码，兼容传递场所code")
    private String hallCode;
    @ApiModelProperty(value = "场次开始时间")
    private LocalDateTime sessionStartTime;
    @ApiModelProperty(value = "场次演出结束时间")
    private LocalDateTime sessionEndTime;
    @ApiModelProperty(value = "是否有座[0：无座1：有座]")
    private Integer hasSeat;
    @ApiModelProperty(value = "票图URL")
    private String seatingChart;
    @ApiModelProperty(value = "标记[0：禁用，1：启用]")
    private Integer tag;
}
