package com.liquidnet.service.sweet.controller.syncRedis;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.impl.syncRedis.JxlDataImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "redis数据迁移-jxl")
@RestController
@RequestMapping("sync")
public class JxlDataController {

    @Autowired
    private JxlDataImpl jxlData;

    /**
     * basicServices
     * @return
     */
    @PostMapping("basicServices/versions")
    @ApiOperation("basicServices版本控制数据迁移")
    public ResponseDto<Boolean> basicServicesVersions() {
        Boolean result = jxlData.basicServicesVersions();
        return ResponseDto.success(result);
    }

    @PostMapping("basicServices/upush")
    @ApiOperation("basicServices推送数据迁移-可不迁暂时无数据")
    public ResponseDto<Boolean> basicServicesUpush() {
        Boolean result = jxlData.basicServicesUpush();
        return ResponseDto.success(result);
    }

    /**
     * sweet
     * @return
     */
    @PostMapping("sweet/accessToken")
    @ApiOperation("sweet-AccessToken数据迁移-可不迁可自动生成")
    public ResponseDto<Boolean> sweetAccessToken() {
        Boolean result = jxlData.sweetAccessToken();
        return ResponseDto.success(result);
    }

    @PostMapping("sweet/answer")
    @ApiOperation("sweet-answer数据迁移")
    public ResponseDto<Boolean> sweetAnswer() {
        Boolean result = jxlData.sweetAnswer();
        return ResponseDto.success(result);
    }

    @PostMapping("sweet/wechatUser/openId")
    @ApiOperation("sweet-wechatUser-openId数据迁移")
    public ResponseDto<Boolean> sweetOpenId() {
        Boolean result = jxlData.sweetOpenId();
        return ResponseDto.success(result);
    }

    @PostMapping("sweet/wechatUser/unionId")
    @ApiOperation("sweet-wechatUser-unionId数据迁移-这里也会同步unionIdStr会抛异常过滤掉")
    public ResponseDto<Boolean> sweetUnionId() {
        Boolean result = jxlData.sweetUnionId();
        return ResponseDto.success(result);
    }

    @PostMapping("sweet/wechatUser/unionIdStr")
    @ApiOperation("sweet-wechatUser-unionIdStr数据迁移")
    public ResponseDto<Boolean> sweetUnionIdStr() {
        Boolean result = jxlData.sweetUnionIdStr();
        return ResponseDto.success(result);
    }

    /**
     * kylin
     * @return
     */
    @PostMapping("kylin/banner")
    @ApiOperation("kylin-banner数据迁移")
    public ResponseDto<Boolean> kylinBanner() {
        Boolean result = jxlData.kylinBanner();
        return ResponseDto.success(result);
    }

    /*kylin:order:ExpressStatus:id:138291855523471362201224 // 无数据暂时 一条是测试
    // 下面会自动降级mongo
    kylin:order:refund:orderId:1000651
    kylin:order:refund:orderRefundsId:1381407542789734445377
    kylin:performances:exclusive
    kylin:performances:notice
    kylin:performances:recommend
    kylin:performances:systemRecommend
    kylin:performances:cityName:七台河
    kylin:performances:id:103866917946163208505924
    kylin:performances:roadShowId:14301561753157632035424*/

}
