package com.liquidnet.service.platform.service.impl.goblin;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExActivityVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExCodeVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExSkuVo;
import com.liquidnet.service.goblin.entity.GoblinNftExCode;
import com.liquidnet.service.goblin.entity.GoblinNftExSku;
import com.liquidnet.service.goblin.mapper.GoblinNftExCodeMapper;
import com.liquidnet.service.goblin.mapper.GoblinNftExSkuMapper;
import com.liquidnet.service.goblin.param.GoblinNftExSkuParam;
import com.liquidnet.service.goblin.service.IGoblinNftExSkuService;
import com.liquidnet.service.platform.utils.GoblinRedisUtils;
import com.liquidnet.service.platform.utils.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: wll
 * @Description: nft兑换活动和和sku的关联
 * @Date:Create：in 2022/4/19 5:14 下午
 */

@Service
@Slf4j
public class GoblinNftExSkuServiceImpl implements IGoblinNftExSkuService {

    @Autowired
    private GoblinNftExCodeMapper goblinNftExCodeMapper;
    @Autowired
    private GoblinNftExSkuMapper goblinNftExSkuMapper;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;


    @Transactional
    @Override
    public Boolean add(List<GoblinNftExSkuParam> goblinNftExSkuParams) {

        LocalDateTime now = LocalDateTime.now();

        ArrayList<GoblinNftExSkuVo> goblinNftExSkuArrayList = ObjectUtil.getGoblinNftExSkuArrayList();
        ArrayList<GoblinNftExCodeVo> goblinNftExCodeArrayList = ObjectUtil.getGoblinNftExCodeArrayList();


        String activityId = "";

        // 构建对象
        for (GoblinNftExSkuParam goblinNftExSkuParam : goblinNftExSkuParams) {
            if (StringUtil.isBlank(activityId)) {
                activityId = goblinNftExSkuParam.getActivityId();
            }
            GoblinNftExSku goblinNftExSku = new GoblinNftExSku();
            BeanUtils.copyProperties(goblinNftExSkuParam, goblinNftExSku);
            goblinNftExSku.setCreatedAt(now);
            // 构建兑换码数量
            for (int i = 0; i < goblinNftExSkuParam.getExStock(); i++) {
                GoblinNftExCode goblinNftExCode = GoblinNftExCode.getNew();
                goblinNftExCode.setCodeId(IDGenerator.nextSnowId());
                goblinNftExCode.setActivityId(goblinNftExSkuParam.getActivityId());
                goblinNftExCode.setCode("");
                goblinNftExCode.setSkuId(goblinNftExSkuParam.getSkuId());
                goblinNftExCode.setState(1);
                goblinNftExCode.setCreatedAt(now);

                goblinNftExCodeArrayList.add(GoblinNftExCodeVo.getNew().copy(goblinNftExCode));
            }
            goblinNftExSkuArrayList.add(GoblinNftExSkuVo.getNew().copy(goblinNftExSku));
        }


        // redis 数据

        // 并联sku信息
/*        List<GoblinNftExSku> goblinNftExSkusVos = goblinRedisUtils.getSku(activityId);
        goblinRedisUtils.incrSku(activityId, goblinNftExSkusVos, goblinNftExSkuArrayList);

        // 兑换码信息
        List<GoblinNftExCode> goblinNftExCodes = goblinRedisUtils.getCode(activityId);
        goblinRedisUtils.incrCode(activityId, goblinNftExCodes, goblinNftExCodeArrayList);*/

        // goblinNftExSkuMapper.addGoblinNftExSkus(goblinNftExSkuArrayList);
        // goblinNftExCodeMapper.addGoblinNftExCodes(goblinNftExCodeArrayList);


        return null;
    }


}
