package com.liquidnet.service.consumer.base.config.goblin;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.base.receiver.goblin.ConsumerGoblinOrderCPRdsReceiver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

@Configuration
public class ConsumerGoblinOrderCPRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerGoblinOrderCPRdsReceiver consumerGoblinOrderCPRdsReceiver;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> orderCP(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.GOBLIN_ORDER_CREATE_PAY;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 5; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinOrderCPRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }
}
