package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtNoticeActionParam", description = "店铺管理:公告通知:操作入参")
@Data
public class GoblinStoreMgtNoticeActionParam implements Serializable {
    private static final long serialVersionUID = 6564996671833040261L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "操作类型[RELEASE-发布|REMOVE-删除]")
    @Pattern(regexp = "\\b(RELEASE|REMOVE)\\b", message = "操作类型无效")
    private String action;
    @ApiModelProperty(position = 12, required = true, value = "公告ID列表")
    private List<String> noticeIdList;
}
