package com.liquidnet.service.consumer.base.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.base.receiver.*;
import com.liquidnet.service.consumer.base.receiver.sweet.ConsumerSweetStoneIntegralReceiver;
import com.liquidnet.service.consumer.base.receiver.sweet.ConsumerSweetTemplateMsgReceiver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

/**
 * 公共的业务队列消息消费器初始化配置
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2022/6/2
 */
@Configuration
public class ConsumerCommonBizRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    ConsumerCommonSmsNoticeReceiver consumerCommonSmsNoticeReceiver;
    @Autowired
    ConsumerGoblinBizArtworkUplReceiver consumerGoblinBizArtworkUplReceiver;
    @Autowired
    ConsumerGoblinBizArtworkClqReceiver consumerGoblinBizArtworkClqReceiver;
    @Autowired
    ConsumerGalaxyJsonNftPublishAndBuyReceiver jsonNftPublishAndBuyReceiver;
    @Autowired
    ConsumerGalaxyJsonNftUserRegisterReceiver jsonNftUserRegisterReceiver;
    @Autowired
    ConsumerGoblinBizIntegralReceiver consumerGoblinBizIntegralReceiver;
    /*------sweet------*/
    @Autowired
    ConsumerSweetTemplateMsgReceiver consumerSweetTemplateMsgReceiver;
    @Autowired
    ConsumerSweetStoneIntegralReceiver consumerSweetStoneIntegralReceiver;
    /*------chime------*/
    @Autowired
    ConsumerChimeUserOperationLikeReceiver consumerChimeUserOperationLikeReceiver;
    @Autowired
    ConsumerChimeUserOperationDislikeReceiver consumerChimeUserOperationDislikeReceiver;

    /*------sweet------*/
    @Bean // 发送模版消息
    public List<Subscription> subscriptionSweetSqlApiTemplateMsg(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.SweetQueue stream = MQConst.SweetQueue.SWEET_TEMPLATE_MSG;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 3; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerSweetTemplateMsgReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }
    @Bean // 增减积分
    public List<Subscription> subscriptionSweetSqlApiStoneIntgral(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.SweetQueue stream = MQConst.SweetQueue.SWEET_STONE_INTEGRAL;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 3; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerSweetStoneIntegralReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean
    public List<Subscription> subscriptionCommonSmsNotice(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.KylinQueue stream = MQConst.KylinQueue.SMS_NOTICE;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 5; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerCommonSmsNoticeReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean
    public List<Subscription> subscriptionGoblinBizArtworkUpl(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.BIZ_ARTWORK_UPL;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinBizArtworkUplReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean
    public List<Subscription> subscriptionGoblinBizArtworkClq(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.BIZ_ARTWORK_CLQ;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinBizArtworkClqReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    /**
     * galaxy发行和购买
     * @param factory
     * @return
     */
    @Bean
    public List<Subscription> subscriptionGalaxyJsonNftPublishAndBuy(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GalaxyQueue stream = MQConst.GalaxyQueue.JSON_NFT_PUBLISH_AND_BUY;

        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 20; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), jsonNftPublishAndBuyReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    /**
     * Galaxy数字账户开通
     * @param factory
     * @return
     */
    @Bean
    public List<Subscription> subscriptionGalaxyJsonNftUserRegister(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GalaxyQueue stream = MQConst.GalaxyQueue.JSON_NFT_USER_REGISTER;

        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 10; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), jsonNftUserRegisterReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean // 增减积分
    public List<Subscription> subscriptionGoblinBizIntegral(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.BIZ_INTEGRAL;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinBizIntegralReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean
    public List<Subscription> subscriptionChimeUserOperationLike(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.ChimeQueue stream = MQConst.ChimeQueue.USER_OPERATION_LIKE;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 10; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerChimeUserOperationLikeReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean
    public List<Subscription> subscriptionChimeUserOperationDislike(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.ChimeQueue stream = MQConst.ChimeQueue.USER_OPERATION_DISLIKE;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 10; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerChimeUserOperationDislikeReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }
}
