package com.liquidnet.service.adam.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "AdamMemberOrderCallbackParam", description = "购买会员或会员码的支付回调")
@Data
public class AdamMemberOrderCallbackParam implements Serializable {
    private static final long serialVersionUID = -4161563334263071103L;
    private Integer status;
    @JsonProperty("order_code")
    private String orderCode;
    private String code;
    @ApiModelProperty(value = "[VIP,CLUB]", allowableValues = "VIP,CLUB")
    private String type;
    private BigDecimal price;
    @JsonProperty("payment_type")
    private String paymentType;
    @JsonProperty("payment_at")
    private String paymentAt;
}
