package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 47.NFT 同名转移
 * @class: NftSeltTransferReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:56
 */
@Data
public class Nft047SelfTransferReq implements Serializable {
    /**
     * nft可操作者的公钥
     */
    private String pubKey;
    /**
     * nft接收者的地址
     */
    private String receiverAddr;
    /**
     * 要转移的nftId
     */
    private String nftId;
    /**
     * 请求ID，每个请求需要填唯一的ID，重复请求用相同的id
     */
    private String operateId;
    /**
     * 操作者的私钥签名，签名对象是(pubKey_receiverAddr_接口名_nftId_operateId)
     * 接口名：nft_transfer
     */
    private String signature;
    private static final Nft047SelfTransferReq obj = new Nft047SelfTransferReq();
    private static final long serialVersionUID = 1026611439106664997L;

    public static Nft047SelfTransferReq getNew() {
        try {
            return (Nft047SelfTransferReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft047SelfTransferReq();
        }
    }
}
