package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.manage.vo.AnticipateValueVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "GoblinNftGoodsSkuInfoVo", description = "NFT商品SKU信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinNftGoodsSkuInfoVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -519573757075729441L;

    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 13, value = "单品的名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "单品的副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 15, value = "单品详情展示文件URL[256]")
    private String skuWatch;
    @ApiModelProperty(position = 15, value = "展示文件类型[1-图片|2-视频|3-模型]")
    private String watchType;

    @ApiModelProperty(position = 18, value = "单品库存")
    private Integer skuStock;

    @ApiModelProperty(position = 21, value = "单品现价[20,2]")
    private BigDecimal price;
    @ApiModelProperty(position = 22, value = "IOS商品价格[20,2]")
    private BigDecimal priceV;

    @ApiModelProperty(position = 23, value = "单品详情", example = "单品详情...")
    private String details;

    @ApiModelProperty(position = 26, value = "限量 0无限制 X限购数量")
    private Integer buyLimit;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 27, value = "开售时间")
    private LocalDateTime saleStartTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 28, value = "系统时间")
    private LocalDateTime systime;

    @ApiModelProperty(position = 33, value = "是否购买[0-否|1-是]")
    private String skuCanbuy;

    @ApiModelProperty(position = 54, value = "单品音乐人标签[藏品类型时使用]")
    private List<GoblinGoodsExtagVo> extagVoList;

    @ApiModelProperty(position = 55, value = "spu相关信息")
    private GoblinNftGoodsSpuInfoVo goblinNftGoodsSpuInfoVo;

    @ApiModelProperty(position = 57, value = "是否还有库存 0没有库存 1有库存 即售罄")
    private int isStock;
    @ApiModelProperty(position = 58, value = "当前用户还可以购买数量 有限购的时候用")
    private int canBuyNum;

    @ApiModelProperty(position = 59, value = "预约开始时间")
    private String aboutStartDate;
    @ApiModelProperty(position = 60, value = "预约结束时间")
    private String aboutEndDate;
    @ApiModelProperty(position = 61, value = "预约状态(0:未开始，1:可预约，3:已结束)")
    private Integer state;
    @ApiModelProperty(position = 62, value = "预约规则")
    private String rule;
    @ApiModelProperty(position = 63, value = "预约人数")
    private BigInteger aboutPeople;
    @ApiModelProperty(position = 64, value = "前三预约头像")
    private List<String> aboutAvatarList;

    private static final GoblinNftGoodsSkuInfoVo obj = new GoblinNftGoodsSkuInfoVo();

    public static GoblinNftGoodsSkuInfoVo getNew() {
        try {
            return (GoblinNftGoodsSkuInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftGoodsSkuInfoVo();
        }
    }

    public GoblinNftGoodsSkuInfoVo copy(GoblinGoodsSkuInfoVo source, AnticipateValueVo anticipateValueVo) {
        if (null == source) return this;
        this.setSkuId(source.getSkuId());
        this.setSpuId(source.getSpuId());
        this.setName(source.getName());
        this.setSubtitle(source.getSubtitle());
        this.setSkuWatch(source.getSkuWatch());
        this.setWatchType(source.getWatchType());
        this.setSkuStock(source.getSkuStock());
        this.setPrice(source.getPrice());
        this.setPriceV(source.getPriceV());
        this.setDetails(source.getDetails());
        this.setBuyLimit(source.getBuyLimit());
        this.setSaleStartTime(source.getSaleStartTime());
        this.setSkuCanbuy(source.getSkuCanbuy());
        this.setExtagVoList(source.getExtagVoList());
        if (anticipateValueVo != null) {
            if (anticipateValueVo.getAboutEndDate() != null) {
                this.setAboutEndDate(DateUtil.Formatter.yyyyMMddHHmmss.format(anticipateValueVo.getAboutEndDate()));
            }
            if (anticipateValueVo.getAboutEndDate() != null) {
                this.setAboutStartDate(DateUtil.Formatter.yyyyMMddHHmmss.format(anticipateValueVo.getAboutStartDate()));
            }
            this.setState(anticipateValueVo.getState());
            this.setRule(anticipateValueVo.getRule());
            this.setAboutPeople(anticipateValueVo.getAboutPeople());
            this.setAboutAvatarList(anticipateValueVo.getAboutAvatarList());
        }
        return this;
    }
}
