package com.liquidnet.service.adam.dto.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel(value = "AdamMemberRightsBuildParam", description = "编辑权益入参")
@Data
public class AdamMemberRightsBuildParam implements Serializable {
    private static final long serialVersionUID = -7331274160877946420L;
    @ApiModelProperty(required = true, value = "会员卡ID")
    @NotBlank(message = "会员类型ID不能为空")
    private String memberId;
    @ApiModelProperty(required = false, value = "权益ID[64]")
    private String mrightsId;
    @ApiModelProperty(required = true, value = "权益状态[1-NORMAL|2-INVALID]")
    @NotNull(message = "会员权益状态不能为空")
    private Integer state;

    @ApiModelProperty(required = true, value = "权益标题[50]")
    @NotBlank(message = "会员权益标题不能为空")
    private String title;
    @ApiModelProperty(required = true, value = "权益副标题[200]")
    @NotNull(message = "会员权益副标题不能为空")
    private String subTitle;
    @ApiModelProperty(required = false, value = "标注[50]")
    private String label;
    @ApiModelProperty(required = true, value = "权益封面图片[255]")
    @NotNull(message = "会员权益封面图片不能为空")
    private String cover;
    @ApiModelProperty(required = false, value = "详情内容")
    private String detail;
    @ApiModelProperty(required = false, value = "展示顺序")
    private Integer seqNo;
}
