package com.liquidnet.service.kylin.dto.vo;

import com.liquidnet.service.kylin.dao.PerformanceOrderStatisticalDao;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PerformanceOrderStatisticalVo
 * @Package com.liquidnet.service.kylin.dto.vo
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/6/19 16:44
 */
@Data
public class PerformanceOrderStatisticalVo implements Cloneable {
    private String performancesId;
    private String ticketsId;
    @ApiModelProperty(value = "票种名称")
    private String title;
    @ApiModelProperty(value = "单价")
    private BigDecimal price;
    @ApiModelProperty(value = "票种类型")
    private Integer type;
    @ApiModelProperty(value = "适用时间")
    private String useStart;
    @ApiModelProperty(value = "适用时间")
    private String useEnd;
    @ApiModelProperty(value = "总库存")
    private BigDecimal totalGeneral = BigDecimal.ZERO;
    @ApiModelProperty(value = "销售数量")
    private BigDecimal saleGeneral = BigDecimal.ZERO;
    @ApiModelProperty(value = "剩余库存")
    private BigDecimal surplusGeneral = BigDecimal.ZERO;
    @ApiModelProperty(value = "销售额")
    private BigDecimal totalSalePrice = BigDecimal.ZERO;
    @ApiModelProperty(value = "兑换数量")
    private BigDecimal totalExchange = BigDecimal.ZERO;
    @ApiModelProperty(value = "退款数量")
    private BigDecimal totalRefundGeneral = BigDecimal.ZERO;
    @ApiModelProperty(value = "退款金额")
    private BigDecimal totalRefundPrice = BigDecimal.ZERO;
    @ApiModelProperty(value = "会员销售数量")
    private BigDecimal totalMemberNumber = BigDecimal.ZERO;
    @ApiModelProperty(value = "正在支付数量")
    private BigDecimal totalPayingNumber = BigDecimal.ZERO;
    @ApiModelProperty(value = "购买人数")
    private BigDecimal totalBuyUsers = BigDecimal.ZERO;

    private static final PerformanceOrderStatisticalVo obj = new PerformanceOrderStatisticalVo();
    public static PerformanceOrderStatisticalVo getNew() {
        try {
            return (PerformanceOrderStatisticalVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new PerformanceOrderStatisticalVo();
        }
    }
}
