-- 2021草莓音乐节海报活动表
drop TABLE if exists `sweet_strawberry_poster`;
CREATE TABLE `sweet_strawberry_poster`
(
    `mid`        bigint unsigned NOT NULL AUTO_INCREMENT,
    `poster_id`  varchar(255)    NOT NULL DEFAULT '' COMMENT 'poster_id',
    `open_id`    varchar(255)    NOT NULL DEFAULT '' COMMENT 'open_id',
    `union_id`   varchar(200)    NOT NULL DEFAULT '' COMMENT 'union_id',
    `nickname`   varchar(255)    NOT NULL DEFAULT '' COMMENT '姓名',
    `city_name`  varchar(255)    NOT NULL DEFAULT '' COMMENT '城市',
    `city_code`  varchar(255)    NOT NULL DEFAULT '' COMMENT  '城市code',
    `custom_text` varchar(255)   NOT NULL DEFAULT '' COMMENT  '自定义文本',
    `created_at` datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at` datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_poster_id` (`poster_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '2021草莓音乐节海报活动表';

-- 2021草莓音乐节海报活动选择阵容表
drop TABLE if exists `sweet_strawberry_poster_lineup`;
CREATE TABLE `sweet_strawberry_poster_lineup`
(
    `mid`           bigint unsigned NOT NULL AUTO_INCREMENT,
    `lineup_id`     varchar(255)    NOT NULL DEFAULT '' COMMENT 'lineup_id',
    `poster_id`     varchar(255)    NOT NULL DEFAULT '' COMMENT 'poster_id',
    `lineup_num`    varchar(255)    NOT NULL DEFAULT 0 COMMENT '阵容编号',
    `musician_id`   int             NOT NULL DEFAULT 0 COMMENT '音乐人id',
    `musician_name` varchar(255)    NOT NULL DEFAULT '' COMMENT '音乐人姓名',
    `created_at`    datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`    datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_lineup_id` (`lineup_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '2021草莓音乐节海报活动选择阵容表';