package com.liquidnet.service.base;

import java.io.Serializable;
import java.util.List;

public class PagedResult<T> implements Serializable, Cloneable {
	private static final long serialVersionUID = 8141034447809038759L;
	/**
     * 总页数
     */
    private int pages;
    /**
     * 总记录数
     */
    private long total;
    /**
     * 分页数据
     */
    private List<T> list;

    public PagedResult() {
    }

    public int getPages() {
        return pages;
    }

//	public PagedResult<T> setTotalPages(int totalPages) {
//		this.totalPages = totalPages;
//		return this;
//	}

    public long getTotal() {
        return total;
    }

    public PagedResult<T> setTotal(long total, int pageSize) {
        this.total = total;
        if (total == -1L) {
            this.pages = 1;
        } else {
            if (pageSize > 0) {
                this.pages = (int) (total / pageSize + (total % pageSize == 0L ? 0 : 1));
            } else {
                this.pages = 0;
            }
        }
        return this;
    }

    public List<T> getList() {
        return list;
    }

    public PagedResult<T> setList(List<T> list) {
        this.list = list;
        return this;
    }

    @Override
    public PagedResult<T> clone() {
        try {
            return (PagedResult<T>) super.clone();
        } catch (CloneNotSupportedException e) {
            return new PagedResult<>();
        }
    }
}
