package com.liquidnet.service.dragon.channel.unionpay.strategy.impl;

import com.liquidnet.service.dragon.channel.alipay.biz.AlipayBiz;
import com.liquidnet.service.dragon.channel.alipay.req.AlipayTradePayReq;
import com.liquidnet.service.dragon.channel.unionpay.strategy.annotation.StrategyUnionpayHandler;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AlipayStrategyWapImpl
 * @Package com.liquidnet.service.dragon.channel.unionpay.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/11/08 18:34
 */
@Slf4j
@Component
@StrategyUnionpayHandler(DragonConstant.DeviceFromEnum.APP)
public class UnionpayStrategyAppImpl extends AbstractUnionPayStrategy {
    @Value("${liquidnet.dragon.alipay.gataway-url}")
    private String alipayGatewayUrl;

    @Value("${liquidnet.dragon.url}")
    private String notifyUrl;

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Autowired
    private AlipayBiz alipayBiz;

    @Override
    protected Map<String, Object> executePay(AlipayTradePayReq alipayTradePayReq) {
        return alipayBiz.tradeAppPay(alipayTradePayReq);
    }

    protected void setProductCode() {
        this.productCode = "QUICK_MSECURITY_PAY";
    }

    @Override
    protected String getNotifyUrl() {
        // notifyUrl = "/notify/app/alipay/1";
        return notifyUrl + "/notify/alipay/app";
    }

    @Override
    DragonPayBaseRespDto buildResponseDto(DragonPayBaseRespDto payBaseRespDto, Map<String, Object> respResult) {
        payBaseRespDto.getPayData().setOrderStr(respResult.get("body").toString());
        return payBaseRespDto;
    }
}
