package com.liquidnet.service.adam.dto.param.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "AdamMembershipParam", description = "编辑会员入参")
@Data
public class AdamMembershipParam implements Serializable {
    private static final long serialVersionUID = -7331274160877946420L;

    @ApiModelProperty(required = true, value = "会员价格ID")
    private String memberPriceId;
    @ApiModelProperty(required = true, value = "原价")
    private BigDecimal price;
    @ApiModelProperty(required = true, value = "折扣价")
    private BigDecimal priceFixed;
    @ApiModelProperty(required = true, value = "特价:首次、首年优惠价")
    private BigDecimal priceSpecial;
    @ApiModelProperty(required = true, value = "有效天数")
    private Integer days;

    @ApiModelProperty(required = true, value = "权益ID[64]")
    private String mrightsId;
    @ApiModelProperty(required = true, value = "权益名称[50]")
    private String title;
    @ApiModelProperty(required = true, value = "权益名称[200]")
    private String subTitle;
    @ApiModelProperty(required = false, value = "标注[50]")
    private String label;
    @ApiModelProperty(required = true, value = "权益封面图片[255]")
    private String cover;
    @ApiModelProperty(required = false, value = "详情内容[50]")
    private String detail;
    @ApiModelProperty(required = true, value = "展示顺序[2]")
    private Integer seqNo;


}
