package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCouponActionParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCouponFilterParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtCouponInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtCouponListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponBasicVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponVo;

import java.util.List;

public interface IGoblinstoreMgtCouponService {
    /**
     * 商铺活动:优惠券列表
     *
     * @param mgtCouponFilterParam GoblinStoreMgtCouponFilterParam
     * @return PagedResult<GoblinStoreMgtCouponListVo>
     */
    PagedResult<GoblinStoreMgtCouponListVo> couponList(GoblinStoreMgtCouponFilterParam mgtCouponFilterParam);

    /**
     * 商铺活动:优惠券启用/停用
     *
     * @param mgtCouponActionParam GoblinStoreMgtCouponActionParam
     * @param uid                  UID
     */
    void couponActivityProcessing(GoblinStoreMgtCouponActionParam mgtCouponActionParam, String uid);

    /**
     * 商铺活动:删除优惠券
     *
     * @param mgtCouponActionParam GoblinStoreMgtCouponActionParam
     * @param uid                  UID
     */
    void couponRemove(GoblinStoreMgtCouponActionParam mgtCouponActionParam, String uid);

    /**
     * 商铺活动:优惠券添加
     *
     * @param uid                UID
     * @param storeCouponBasicVo GoblinStoreCouponBasicVo
     */
    void couponAdd(String uid, GoblinStoreCouponBasicVo storeCouponBasicVo);

    /**
     * 商铺活动:优惠券详情
     *
     * @param storeId       店铺ID
     * @param storeCouponId 优惠券ID
     * @return GoblinStoreMgtCouponInfoVo
     */
    GoblinStoreMgtCouponInfoVo couponInfo(String storeId, String storeCouponId);

    /**
     * 商铺活动:优惠券编辑
     *
     * @param uid                UID
     * @param storeCouponBasicVo GoblinStoreCouponBasicVo
     * @param beforeSpuIdList    List<String>
     * @return boolean
     */
    boolean couponEdit(String uid, GoblinStoreCouponBasicVo storeCouponBasicVo, List<String> beforeSpuIdList);

    /**
     * 商铺活动:优惠券库存编辑
     *
     * @param storeCouponVo GoblinStoreCouponVo
     * @param uid           UID
     * @param operStock     int
     * @return boolean
     */
    boolean couponEditStock(GoblinStoreCouponVo storeCouponVo, String uid, int operStock);
}
