package com.liquidnet.service.adam.service.processor;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.ServletUtils;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.adam.entity.AdamEnters;
import com.liquidnet.service.adam.mapper.AdamEntersMapper;
import com.liquidnet.service.adam.service.DataMigrationProcessorService;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class DMEntersProcessor extends DataMigrationProcessorService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    AdamEntersMapper entersMapper;

    @SneakyThrows
    @Override
    protected void dataProcessing(boolean flg) {
        if (StringUtils.isNotEmpty(ServletUtils.getRequest().getParameter(DM_FLUSH))) {
            log.info("DM.flush.enters:{}", userMapper.executeForDM("adam_enters"));

            log.info("DM.flush.AdamEntersVo:{}", mongoTemplate.remove(Query.query(Criteria.where("_id").exists(true)), AdamEntersVo.class.getSimpleName()).getDeletedCount());
        }

        String sqlCount = "select count(1) from enters where (type <> 1 or (type = 1 and is_certification = 'yes'))";
        String field = "id,user_id,type,`name`,mobile,idcode,if(is_default='no', 0, 1),created_at";
//                     1-id,2-user_id,3-type,4-`name`,5-mobile,6-idcode,7-if(is_default='no', 0, 1),8-created_at
        String sql = sqlCount.replace("count(1)", field);

        if (flg) {
            sqlCount += " and user_id in ('2026628','544327','1997335','773650','809406')";
            sql += " and user_id in ('2026628','544327','1997335','773650','809406')";
        }

        sql += " limit ?,?";

        statement = connection.prepareStatement(sqlCount);
        row = (ResultSetImpl) statement.executeQuery();
        row.first();
        int ct = row.getInt(1), pSize = 1000, num = 0;
        log.info("DM数据迁移总数:{}", ct);


        while (ct > 0) {
            statement = connection.prepareStatement(sql);
            statement.setInt(1, pSize * num);
            statement.setInt(2, pSize);
            row = (ResultSetImpl) statement.executeQuery();
            log.info("DM.execute.limit:[pNo:{},pSize:{}]", pSize * num, pSize);
            while (row.next()) {
                String uid = row.getString(2);

                if (!reUidList.contains(uid)) {
                    AdamEnters enters = new AdamEnters();
                    enters.setEntersId(row.getString(1));
                    enters.setUid(uid);
                    enters.setType(row.getInt(3));
                    enters.setName(row.getString(4));
                    enters.setMobile(row.getString(5));
                    enters.setIdCard(row.getString(6));
                    enters.setIsDefault(row.getBoolean(7));
                    enters.setState(1);
                    enters.setCreatedAt(row.getLocalDateTime(8));

                    AdamEntersVo vo = AdamEntersVo.getNew().copy(enters);

                    entersMapper.insert(enters);
                    mongoTemplate.insert(vo, AdamEntersVo.class.getSimpleName());
                }
            }
            

            num++;
            ct -= pSize;
        }
    }
}
