package com.liquidnet.service.smile.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 志愿者-志愿者表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SmileVolunteers implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 活动id
     */
    private String projectId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 头像
     */
    private String img;

    /**
     * 证件号
     */
    private String idCard;

    /**
     * 性别[0-未知|1-男|2-女]
     */
    private Integer sex;

    /**
     * 状态[0-待审核|1-审核通过|2-审核未通过]
     */
    private Integer status;

    /**
     * 学校
     */
    private String school;

    /**
     * 学校地址
     */
    private String schoolAddress;

    /**
     * 专长
     */
    private String specialty;

    /**
     * 特长
     */
    private String specialty2;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 微信号
     */
    private String wxNum;

    /**
     * 申请组ID-1
     */
    private String teamId1;

    /**
     * 申请组ID-2
     */
    private String teamId2;

    /**
     * 申请组ID-3
     */
    private String teamId3;

    /**
     * 自我介绍
     */
    private String introduce;

    /**
     * 补充字段
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
