package com.liquidnet.service.goblin.controller.Inner;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.impl.inner.GoblinQueBizArtworkClqService;
import com.liquidnet.service.goblin.service.impl.inner.GoblinQueBizArtworkUplService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

@Slf4j
@Api(tags = "@API:QUE")
@RestController
@Validated
@RequestMapping("que/artwork")
public class GoblinQueBizArtworkController {
    @Autowired
    private GoblinQueBizArtworkUplService goblinQueBizArtworkUplService;
    @Autowired
    private GoblinQueBizArtworkClqService goblinQueBizArtworkClqService;

    @PostMapping("upl")
    @ApiOperation("藏品上传声明")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "skuId", value = "藏品ID", example = "1"),
    })
    public ResponseDto<String> bizArtworkUpl(@NotBlank(message = "藏品ID不能为空") @RequestParam String skuId) {
        return goblinQueBizArtworkUplService.bizArtworkUplProcessing(skuId);
    }

    @PostMapping("clq")
    @ApiOperation("藏品声明查询")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "skuId", value = "藏品ID", example = "1"),
    })
    public ResponseDto<String> bizArtworkClq(@NotBlank(message = "藏品ID不能为空") @RequestParam String skuId) {
        return goblinQueBizArtworkClqService.bizArtworkClqProcessing(skuId);
    }
}
