package com.liquidnet.service.goblin.service.impl.manage;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.candy.vo.CandyCouponVo;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.entity.GoblinBackOrder;
import com.liquidnet.service.goblin.entity.GoblinBackOrderLog;
import com.liquidnet.service.goblin.entity.GoblinOrderOperationLog;
import com.liquidnet.service.goblin.param.BackCouponParam;
import com.liquidnet.service.goblin.param.RefundCallbackParam;
import com.liquidnet.service.goblin.service.GoblinCouponService;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMoneyService;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreOrderService;
import com.liquidnet.service.goblin.util.*;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.UpdateResult;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

@Service
@Slf4j
public class GoblinStoreOrderServiceImpl implements IGoblinStoreOrderService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    GoblinOrderUtils orderUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinCouponService goblinCouponService;
    @Value("${liquidnet.service.order.url-pay.goblinRefundUrl}")
    private String synUrl;
    @Value("${liquidnet.service.dragon.urls.refundApply}")
    private String refundApply;

    @Override
    public ResponseDto<PageInfo<GoblinStoreOrderListVo>> orderList(Integer page, String orderCode, Integer type, String cst, String cet, String expressContacts, String phone, Integer status) {
        List<GoblinStoreOrderListVo> listVos = ObjectUtil.getGoblinStoreOrderListVoArrayList();
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        HashMap<String, Object> map = mongoUtils.storeOrderList(storeInfoVo.getStoreId(), page, orderCode, cst, cet, expressContacts, phone, status);
        long total = (long) map.get("total");
        List<GoblinStoreOrderVo> voList = (List<GoblinStoreOrderVo>) map.get("data");
        for (GoblinStoreOrderVo item : voList) {
            GoblinStoreOrderListVo vo = GoblinStoreOrderListVo.getNew();
            vo.setCreatedAt(item.getCreatedAt());
            vo.setExpressAddressDetail(item.getOrderAttrVo().getExpressAddressDetail());
            vo.setExpressContacts(item.getOrderAttrVo().getExpressContacts());
            vo.setExpressPhone(item.getOrderAttrVo().getExpressPhone());
            vo.setOrderCode(item.getOrderCode());
            vo.setExpressAddress(item.getOrderAttrVo().getExpressAddress());
            vo.setOrderId(item.getOrderId());
            vo.setPayType(item.getPayType());
            vo.setPriceActual(item.getPriceActual());
            vo.setStatus(item.getStatus());
            vo.setMarketType(item.getMarketType());
            vo.setPriceExpress(item.getPriceExpress());
            if (item.getMarketId() == null || item.getMarketId().equals("")) {
                vo.setMarketName("");
            } else {
                GoblinSelfMarketingVo marketingVo = redisUtils.getSelfMarket(item.getMarketId().split("ZZ")[1]);
                vo.setMarketName(marketingVo.getName());
            }
            List<GoblinStoreOrderListSkuVo> orderListSkuVos = ObjectUtil.getGoblinStoreOrderListSkuVoArrayList();
            for (String skuId : item.getOrderSkuVoIds()) {
                GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(skuId);
                GoblinStoreOrderListSkuVo itemSkuVo = GoblinStoreOrderListSkuVo.getNew();
                itemSkuVo.setNum(orderSkuVo.getNum());
                itemSkuVo.setOrderSkuId(orderSkuVo.getOrderSkuId());
                itemSkuVo.setSkuId(orderSkuVo.getSkuId());
                itemSkuVo.setSkuName(orderSkuVo.getSkuName());
                itemSkuVo.setSpuName(orderSkuVo.getSpuName());
                itemSkuVo.setSkuPriceActual(orderSkuVo.getSkuPriceActual());
                itemSkuVo.setSkuSpecs(orderSkuVo.getSkuSpecs());
                itemSkuVo.setSkuImage(orderSkuVo.getSkuImage());
                itemSkuVo.setStatus(orderSkuVo.getStatus());
                itemSkuVo.setPrice(orderSkuVo.getSkuPrice());
                itemSkuVo.setPriceVoucher(orderSkuVo.getPriceVoucher());
                orderListSkuVos.add(itemSkuVo);
            }
            vo.setStoreOrderListSkuVoList(orderListSkuVos);
            listVos.add(vo);
        }
        PageInfo<GoblinStoreOrderListVo> pageInfo = new PageInfo(listVos);
        pageInfo.setTotal(total);
        return ResponseDto.success(pageInfo);
    }

    @Override
    public ResponseDto<GoblinStoreOrderListVo> orderDetails(String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderListVo vo = GoblinStoreOrderListVo.getNew();
        vo.setCreatedAt(orderVo.getCreatedAt());
        vo.setExpressAddressDetail(orderVo.getOrderAttrVo().getExpressAddressDetail());
        vo.setExpressContacts(orderVo.getOrderAttrVo().getExpressContacts());
        vo.setExpressPhone(orderVo.getOrderAttrVo().getExpressPhone());
        vo.setOrderCode(orderVo.getOrderCode());
        vo.setExpressAddress(orderVo.getOrderAttrVo().getExpressAddress());
        vo.setOrderId(orderVo.getOrderId());
        vo.setPayType(orderVo.getPayType());
        vo.setPriceActual(orderVo.getPriceActual());
        vo.setStatus(orderVo.getStatus());
        vo.setPayTime(orderVo.getPayTime());
        vo.setPriceExpress(orderVo.getPriceExpress());
        if (!(orderVo.getUcouponId() == null || orderVo.getUcouponId().equals(""))) {
            CandyCouponVo candyCouponVo = orderUtils.getCouponDetails(orderVo.getUcouponId(), orderVo.getUserId());
            vo.setPlatformUcouponId(candyCouponVo.getUcouponId());
            vo.setPlatformUcouponName(candyCouponVo.getTitle());
            vo.setPlatformUcouponPrice(orderVo.getPriceCoupon());
        } else {
            vo.setPlatformUcouponId("");
            vo.setPlatformUcouponName("");
            vo.setPlatformUcouponPrice(BigDecimal.ZERO);
        }
        if (!(orderVo.getStoreCouponId() == null || orderVo.getStoreCouponId().equals(""))) {
            List<GoblinUserCouponVo> voList = redisUtils.getUserCouponVos(orderVo.getUserId());
            for (GoblinUserCouponVo goblinUserCouponVo : voList) {
                if (goblinUserCouponVo.getUcouponId().equals(orderVo.getStoreCouponId())) {
                    vo.setStoreUcouponId(goblinUserCouponVo.getStoreCouponId());
                    vo.setStoreUcouponName(goblinUserCouponVo.getTitle());
                    vo.setStoreUcouponPrice(orderVo.getStorePriceCoupon());
                    break;
                }
            }

        } else {
            vo.setStoreUcouponId("");
            vo.setStoreUcouponName("");
            vo.setStoreUcouponPrice(BigDecimal.ZERO);
        }
        if (orderVo.getMarketId() == null || orderVo.getMarketId().equals("")) {
            vo.setMarketName("");
        } else {
            GoblinSelfMarketingVo marketingVo = redisUtils.getSelfMarket(orderVo.getMarketId().split("ZZ")[1]);
            vo.setMarketName(marketingVo.getName());
        }

        vo.setGoblinMailVoList(redisUtils.getGoblinMail(orderId));
        List<GoblinStoreOrderListSkuVo> orderListSkuVos = ObjectUtil.getGoblinStoreOrderListSkuVoArrayList();
        for (String skuId : orderVo.getOrderSkuVoIds()) {
            GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(skuId);
            GoblinStoreOrderListSkuVo itemSkuVo = GoblinStoreOrderListSkuVo.getNew();
            itemSkuVo.setNum(orderSkuVo.getNum());
            itemSkuVo.setOrderSkuId(orderSkuVo.getOrderSkuId());
            itemSkuVo.setSkuId(orderSkuVo.getSkuId());
            itemSkuVo.setSkuName(orderSkuVo.getSkuName());
            itemSkuVo.setSpuName(orderSkuVo.getSpuName());
            itemSkuVo.setSkuPriceActual(orderSkuVo.getSkuPriceActual());
            itemSkuVo.setSkuSpecs(orderSkuVo.getSkuSpecs());
            itemSkuVo.setSkuImage(orderSkuVo.getSkuImage());
            itemSkuVo.setStatus(orderSkuVo.getStatus());
            itemSkuVo.setPrice(orderSkuVo.getSkuPrice());
            itemSkuVo.setPriceVoucher(orderSkuVo.getPriceVoucher());
            orderListSkuVos.add(itemSkuVo);
        }
        vo.setStoreOrderListSkuVoList(orderListSkuVos);
        return ResponseDto.success(vo);
    }

    @Override
    public ResponseDto<Boolean> orderCancel(String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.getNowTime();
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsOrder = CollectionUtil.linkedListObjectArr();
        LinkedList<Object[]> sqlsOrderSku = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("goblin_order.store.cancel"));
        sqls.add(SqlMapping.get("goblin_order.store.orderSkuStatus"));
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        if (!orderVo.getStatus().equals(GoblinStatusConst.Status.ORDER_STATUS_0.getValue())) {
            return ResponseDto.failure("无法取消");
        }
        orderVo.setStatus(GoblinStatusConst.Status.ORDER_STATUS_5.getValue());
        orderVo.setCancelReason("商铺取消");
        orderVo.setCancelTime(nowStr);
        for (String orderSkuId : orderVo.getOrderSkuVoIds()) {
            GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(orderSkuId);
            orderSkuVo.setStatus(GoblinStatusConst.Status.ORDER_STATUS_5.getValue());
            //redis
            String pre = GoblinStatusConst.MarketPreStatus.getPre(orderSkuVo.getSkuId());

            redisUtils.setGoblinOrderSku(orderSkuId, orderSkuVo);
            redisUtils.incrSkuStock(pre, orderSkuVo.getSkuId(), orderSkuVo.getNum());
            redisUtils.decrSkuCountByUid(orderVo.getUserId(), orderSkuVo.getSkuId(), orderSkuVo.getNum());
            //mongo
            mongoUtils.updateGoblinOrderSkuVo(orderSkuId, orderSkuVo);
            //mysql
            sqlsOrderSku.add(new Object[]{
                    orderSkuVo.getStatus(), now,
                    orderSkuVo.getOrderSkuId(), now, now
            });
        }
        GoblinOrderOperationLog log = initLog(orderId, uid, now);
        log.setType(GoblinStatusConst.Status.ORDER_LOG_STATUS_14.getValue());
        log.setRemark("商铺取消订单");

        //回退平台券
        if (!(orderVo.getUcouponId() == null || orderVo.getUcouponId().equals(""))) {
            orderUtils.backCoupon(orderVo.getUcouponId(), orderVo.getUserId());
        }
        //回退店铺券
        if (!(orderVo.getStoreCouponId() == null || orderVo.getStoreCouponId().equals(""))) {
            List<BackCouponParam> params = ObjectUtil.getBackCouponParam();
            BackCouponParam backCouponParam = BackCouponParam.getNew();
            backCouponParam.setuCouponIds(orderVo.getStoreCouponId());
            backCouponParam.setUid(orderVo.getUserId());
            params.add(backCouponParam);
            goblinCouponService.backCoupon(params);
        }

        //redis
        redisUtils.setGoblinOrder(orderId, orderVo);
        //mongo
        mongoUtils.updateGoblinStoreOrderVo(orderId, orderVo);
        //mysql
        sqlsOrder.add(new Object[]{
                orderVo.getStatus(), now, orderVo.getCancelReason(), now,
                orderId, now, now
        });
        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.gets(sqls, sqlsOrder, sqlsOrderSku));
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> changeExpressPrice(String orderId, BigDecimal price) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        if (orderVo.getStatus() == GoblinStatusConst.Status.ORDER_STATUS_3.getValue()) {
            return ResponseDto.failure("已发货");
        }
        BigDecimal voucherExpress = orderVo.getPriceExpress().subtract(price);
        orderVo.setPriceTotal(orderVo.getPriceTotal().subtract(voucherExpress));
        orderVo.setPriceModify(orderVo.getPriceModify().add(voucherExpress));
//        orderVo.setPriceVoucher(orderVo.getPriceVoucher().add(voucherExpress));
        orderVo.setPriceActual(orderVo.getPriceActual().subtract(voucherExpress));
        orderVo.setPriceExpress(price);
        GoblinOrderOperationLog log = initLog(orderId, uid, now);
        log.setType(GoblinStatusConst.Status.ORDER_LOG_STATUS_17.getValue());
        log.setRemark("修改快递价格，expressPress=[" + price + "]");
        //redis
        redisUtils.setGoblinOrder(orderId, orderVo);
        //mongo
        mongoUtils.updateGoblinStoreOrderVo(orderId, orderVo);
        //mysql
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.orderExpressPrice",
                        orderVo.getPriceTotal(), orderVo.getPriceModify(), orderVo.getPriceVoucher(), orderVo.getPriceActual(), orderVo.getPriceExpress(), now,
                        orderId, now, now
                )
        );
        //添加日志
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.log",
                        log.getOrderLogId(), log.getOrderId(), log.getType(), log.getRemark(), log.getOperationName(), now
                )
        );
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> changeAddress(String orderId, String expressContacts, String expressPhone, String expressAddressDetail) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        if (orderVo.getStatus() == GoblinStatusConst.Status.ORDER_STATUS_3.getValue()) {
            return ResponseDto.failure("已发货");
        }
        orderVo.getOrderAttrVo().setExpressAddressDetail(expressAddressDetail);
        orderVo.getOrderAttrVo().setExpressContacts(expressContacts);
        orderVo.getOrderAttrVo().setExpressPhone(expressPhone);
        GoblinOrderOperationLog log = initLog(orderId, uid, now);
        log.setType(GoblinStatusConst.Status.ORDER_LOG_STATUS_17.getValue());
        log.setRemark("修改收货地址，expressContacts=[" + expressContacts + "],expressPhone=[" + expressPhone + "],expressAddressDetail=[" + expressAddressDetail + "]");
        //redis
        redisUtils.setGoblinOrder(orderId, orderVo);
        //mongo
        mongoUtils.updateGoblinStoreOrderVo(orderId, orderVo);
        //mysql
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.address",
                        expressContacts, expressAddressDetail, expressPhone, now, orderId, now, now
                )
        );
        //添加日志
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.log",
                        log.getOrderLogId(), log.getOrderId(), log.getType(), log.getRemark(), log.getOperationName(), now
                )
        );
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> changeSkuPrice(String orderId, String orderSkuId, BigDecimal price) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        if (orderVo.getStatus() == GoblinStatusConst.Status.ORDER_STATUS_3.getValue()) {
            return ResponseDto.failure("已发货");
        }
        GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(orderSkuId);
        if (orderSkuVo == null) {
            return ResponseDto.failure("不存在");
        }
        BigDecimal voucherPrice = orderSkuVo.getSkuPriceActual().subtract(price);
        orderSkuVo.setPriceModify(orderSkuVo.getPriceModify() == null ? price : orderSkuVo.getPriceModify().add(price));
//        orderSkuVo.setPriceVoucher(orderSkuVo.getPriceVoucher().add(voucherPrice));
        orderSkuVo.setSkuPriceActual(orderSkuVo.getSkuPriceActual().subtract(voucherPrice));
        orderVo.setPriceTotal(orderVo.getPriceTotal().subtract(voucherPrice));
        orderVo.setPriceModify(orderVo.getPriceModify().add(voucherPrice));
//        orderVo.setPriceVoucher(orderVo.getPriceVoucher().add(voucherPrice));
        orderVo.setPriceActual(orderVo.getPriceActual().subtract(voucherPrice));
        GoblinOrderOperationLog log = initLog(orderId, uid, now);
        log.setType(GoblinStatusConst.Status.ORDER_LOG_STATUS_12.getValue());
        log.setRemark("修改金额，orderSkuId=[" + orderSkuId + "],price=[" + price + "]");
        //redis
        redisUtils.setGoblinOrder(orderId, orderVo);
        redisUtils.setGoblinOrderSku(orderSkuId, orderSkuVo);
        //mongo
        mongoUtils.updateGoblinStoreOrderVo(orderId, orderVo);
        mongoUtils.updateGoblinOrderSkuVo(orderSkuId, orderSkuVo);
        //mysql
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsOrder = CollectionUtil.linkedListObjectArr();
        LinkedList<Object[]> sqlsOrderSku = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("goblin_order.store.orderPrice"));
        sqls.add(SqlMapping.get("goblin_order.store.orderSkuPrice"));
        sqlsOrder.add(new Object[]{
                orderVo.getPriceModify(), orderVo.getPriceVoucher(), orderVo.getPriceActual(), now,
                orderId, now, now
        });
        sqlsOrderSku.add(new Object[]{
                orderSkuVo.getPriceModify(), orderSkuVo.getPriceVoucher(), orderSkuVo.getSkuPriceActual(), now,
                orderSkuId, now, now
        });
        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.gets(sqls, sqlsOrder, sqlsOrderSku));
        //添加日志
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.log",
                        log.getOrderLogId(), log.getOrderId(), log.getType(), log.getRemark(), log.getOperationName(), now
                )
        );
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> refundOrderSku(String orderId, String orderSkuId, BigDecimal price) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.getNowTime();
        List<GoblinBackOrderSkuVo> orderSkuVoList = ObjectUtil.goblinBackOrderSkuVoArrayList();
        BigDecimal refundPrice = price;
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        if (orderSkuId != null) {
            GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(orderSkuId);
            if (orderSkuVo == null) {
                return ResponseDto.failure("不存在");
            }
            GoblinBackOrderSkuVo backOrderSkuVo = GoblinBackOrderSkuVo.getNew();
            backOrderSkuVo.setOrderSkuId(orderSkuId);
            backOrderSkuVo.setSpuId(orderSkuVo.getSpuId());
            backOrderSkuVo.setSpuName(orderSkuVo.getSpuName());
            backOrderSkuVo.setSkuId(orderSkuVo.getSkuId());
            backOrderSkuVo.setSkuName(orderSkuVo.getSkuName());
            backOrderSkuVo.setRefundPrice(price);
            backOrderSkuVo.setSkuSpecs(orderSkuVo.getSkuSpecs());
            backOrderSkuVo.setCreatedAt(nowStr);
            backOrderSkuVo.setSkuPic(orderSkuVo.getSkuImage());
            orderSkuVoList.add(backOrderSkuVo);
            BigDecimal backOrderSkuVoPrice = mongoUtils.getRefundOrderSkuVoPrice(orderSkuId);
            if (price.compareTo(orderSkuVo.getSkuPriceActual().subtract(backOrderSkuVoPrice)) > 0) {
                return ResponseDto.failure("退款价格超过商品可退价格");
            }
        } else {
            refundPrice = BigDecimal.ZERO;
            for (String orderSkuIdItem : orderVo.getOrderSkuVoIds()) {
                GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(orderSkuIdItem);
                GoblinBackOrderSkuVo backOrderSkuVo = GoblinBackOrderSkuVo.getNew();
                backOrderSkuVo.setOrderSkuId(orderSkuIdItem);
                backOrderSkuVo.setSpuId(orderSkuVo.getSpuId());
                backOrderSkuVo.setSpuName(orderSkuVo.getSpuName());
                backOrderSkuVo.setSkuId(orderSkuVo.getSkuId());
                backOrderSkuVo.setSkuName(orderSkuVo.getSkuName());
                backOrderSkuVo.setRefundPrice(orderSkuVo.getSkuPriceActual());
                backOrderSkuVo.setSkuSpecs(orderSkuVo.getSkuSpecs());
                backOrderSkuVo.setCreatedAt(nowStr);
                backOrderSkuVo.setSkuPic(orderSkuVo.getSkuImage());
                orderSkuVoList.add(backOrderSkuVo);
                refundPrice = refundPrice.add(orderSkuVo.getSkuPriceActual().subtract(orderSkuVo.getPriceRefund()));
            }
        }
        //记录退款单
        String refundCode = IDGenerator.storeRefundCode(orderVo.getMasterOrderCode());
        GoblinBackOrder goblinBackOrder = GoblinBackOrder.getNew();
        goblinBackOrder.setBackOrderId(IDGenerator.nextTimeId2());
        goblinBackOrder.setBackCode(refundCode);
        goblinBackOrder.setOrderId(orderVo.getOrderId());
        goblinBackOrder.setOrderCode(orderVo.getOrderCode());
        goblinBackOrder.setStoreId(orderVo.getStoreId());
        goblinBackOrder.setUserId(orderVo.getUserId());
        goblinBackOrder.setSkuIdNums(orderSkuId);
        goblinBackOrder.setType(GoblinStatusConst.Type.BACK_TYPE_1.getValue());
        goblinBackOrder.setReason(GoblinStatusConst.Type.BACK_REASON_TYPE_8.getDesc());
        goblinBackOrder.setDescribes("店铺退款");
        refundPrice = refundPrice.add(orderVo.getPriceExpress());
        goblinBackOrder.setRealBackPrice(refundPrice);
        goblinBackOrder.setStatus(GoblinStatusConst.Status.ORDER_BACK_STATUS_0.getValue());
        goblinBackOrder.setAuditAt(now);
        goblinBackOrder.setCreatedAt(now);
        GoblinBackOrderVo backOrderVo = GoblinBackOrderVo.getNew();
        BeanUtils.copyProperties(goblinBackOrder, backOrderVo);
        backOrderVo.setCreatedAt(nowStr);
        backOrderVo.setBackOrderSkuVos(orderSkuVoList);
        //添加日志
        GoblinBackOrderLog backOrderLog = initBackLog(goblinBackOrder.getBackOrderId(), uid, now);
        backOrderLog.setStatus(GoblinStatusConst.Status.ORDER_LOG_STATUS_22.getValue());
        backOrderLog.setOperationType(GoblinStatusConst.Type.OPERATION_TYPE_2.getValue());
        backOrderLog.setMessage("商户发起：orderSkuId=[" + orderSkuId + "],refundPrice=[" + refundPrice + "],[refundCode=" + refundCode + "]");
        //调用退款
        String returnString = initRefund(orderVo, refundPrice, refundCode);
        HashMap hashMapResult = JsonUtils.fromJson(returnString, HashMap.class);
        Boolean success = (Boolean) hashMapResult.get("success");
        String message = (String) hashMapResult.get("message");
        if (!success) {
            if (!(backOrderVo.getStatus() == GoblinStatusConst.Status.ORDER_BACK_STATUS_8.getValue() || backOrderVo.getStatus() == GoblinStatusConst.Status.ORDER_BACK_STATUS_2.getValue())) {
                backOrderVo.setStatus(GoblinStatusConst.Status.ORDER_BACK_STATUS_10.getValue());
                backOrderVo.setErrorReason(backOrderVo.getErrorReason() + ",失败原因：" + message);
                log.error("REFUND DATA = " + returnString);
            }
        }
        //redis
        redisUtils.setBackOrderVo(backOrderVo.getBackOrderId(), backOrderVo);
        redisUtils.addBackOrderByOrderId(orderVo.getOrderId(), backOrderVo.getBackOrderId());
        //mongo
        mongoUtils.insertGoblinBackOrderVo(backOrderVo);
        //添加退款
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.backOrder",
                        goblinBackOrder.getBackOrderId(), goblinBackOrder.getBackCode(), goblinBackOrder.getOrderId(),
                        goblinBackOrder.getOrderCode(), goblinBackOrder.getStoreId(), goblinBackOrder.getUserId(),
                        goblinBackOrder.getSkuIdNums(), goblinBackOrder.getType(), goblinBackOrder.getReason(),
                        goblinBackOrder.getDescribes(), goblinBackOrder.getRealBackPrice(), goblinBackOrder.getStatus(),
                        goblinBackOrder.getCreatedAt(), goblinBackOrder.getAuditAt(), goblinBackOrder.getErrorReason()
                )
        );
        //添加日志
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.refundLog",
                        backOrderLog.getBackOrderLogId(), backOrderLog.getBackOrderId(), backOrderLog.getOperationType(),
                        backOrderLog.getMessage(), backOrderLog.getOperationName(), backOrderLog.getStatus(), now
                )
        );
        if (success) {
            return ResponseDto.success();
        }
        return ResponseDto.failure("退款失败:" + message);
    }

    @Override
    public ResponseDto<Boolean> express(String orderId, String orderSkuIds, String mailNo,String uid) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.getNowTime();
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsOrder = CollectionUtil.linkedListObjectArr();
        LinkedList<Object[]> sqlsOrderSku = CollectionUtil.linkedListObjectArr();
        LinkedList<Object[]> sqlsMail = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("goblin_order.store.express"));
        sqls.add(SqlMapping.get("goblin_order.store.orderSkuStatus"));
        sqls.add(SqlMapping.get("goblin_order.mail"));
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        if (orderVo.getStatus() != GoblinStatusConst.Status.ORDER_STATUS_2.getValue()) {
            return ResponseDto.failure("无法发货");
        }
        List<String> backOrderIds = redisUtils.getBackOrderByOrderId(orderId);
        for (String backOrderId : backOrderIds) {
            GoblinBackOrderVo backOrderVo = redisUtils.getBackOrderVo(backOrderId);
            if (!(backOrderVo.getStatus().equals(GoblinStatusConst.Status.ORDER_BACK_STATUS_3.getValue()) || backOrderVo.getStatus().equals(GoblinStatusConst.Status.ORDER_BACK_STATUS_5.getValue()) || backOrderVo.getStatus().equals(GoblinStatusConst.Status.ORDER_BACK_STATUS_9.getValue()))) {
                return ResponseDto.failure("申请失败");
            }
        }
        List<String> skuIds;
        if (orderSkuIds == null) {
            skuIds = orderVo.getOrderSkuVoIds();
        } else {
            skuIds = Arrays.asList(orderSkuIds.split(","));
        }
        GoblinMailVo mailVo = GoblinMailVo.getNew();
        mailVo.setMailId(IDGenerator.nextTimeId2());
        mailVo.setOrderId(orderVo.getOrderId());
        mailVo.setMailNo(mailNo);
        mailVo.setDeliveryTime(nowStr);
        mailVo.setLogisticsCompany("松鼠德邦");
        mailVo.setOrderSkuVoIds(skuIds);

        //redis
        redisUtils.addGoblinMail(orderId, mailVo);
        //mongo
        mongoUtils.insertGoblinMailVo(mailVo);
        //mysql
        sqlsMail.add(new Object[]{
                mailVo.getMailId(), mailVo.getOrderId(), mailVo.getMailNo(), mailVo.getDeliveryTime(),
                mailVo.getLogisticsCompany(), StringUtils.join(mailVo.getOrderSkuVoIds(), ","), now
        });

        for (String orderSkuId : skuIds) {
            GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(orderSkuId);
            if(orderSkuVo==null){
                log.error("调过子订单号:"+orderSkuId);
                continue;
            }
            orderSkuVo.setStatus(GoblinStatusConst.Status.ORDER_STATUS_3.getValue());
            //redis
            redisUtils.setGoblinOrderSku(orderSkuId, orderSkuVo);
            //mongo
            mongoUtils.updateGoblinOrderSkuVo(orderSkuId, orderSkuVo);
            //mysql
            sqlsOrderSku.add(new Object[]{
                    orderSkuVo.getStatus(), now,
                    orderSkuVo.getOrderSkuId(), now, now
            });
        }
        int sendSize = 0;
        for (String orderSkuId : orderVo.getOrderSkuVoIds()) {
            GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(orderSkuId);
            if (orderSkuVo.getStatus() == GoblinStatusConst.Status.ORDER_STATUS_3.getValue() || orderSkuVo.getStatus() == GoblinStatusConst.Status.ORDER_STATUS_4.getValue()) {
                sendSize++;
            }
        }
        if (sendSize == orderVo.getOrderSkuVoIds().size()) {
            orderVo.setStatus(GoblinStatusConst.Status.ORDER_STATUS_3.getValue());
        }

        GoblinOrderOperationLog log = initLog(orderId, uid, now);
        log.setType(GoblinStatusConst.Status.ORDER_LOG_STATUS_13.getValue());
        log.setRemark("发货：orderId=[" + orderId + "],orderSkuId=[" + StringUtils.join(skuIds, ",") + "],mailNo=[" + mailNo + "]");

        //redis
        redisUtils.setGoblinOrder(orderId, orderVo);
        //mongo
        mongoUtils.updateGoblinStoreOrderVo(orderId, orderVo);
        //mysql
        sqlsOrder.add(new Object[]{
                orderVo.getStatus(), now, orderId, now, now
        });
        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.gets(sqls, sqlsOrder, sqlsOrderSku, sqlsMail));
        //添加日志
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.log",
                        log.getOrderLogId(), log.getOrderId(), log.getType(), log.getRemark(), log.getOperationName(), now
                )
        );
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> changeExpressMailNo(String orderId, String mailId, String mailNo) {
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        GoblinMailVo vo = GoblinMailVo.getNew();
        vo.setMailNo(mailNo);
        vo.setMailId(mailId);
        vo.setOrderId(orderId);
        redisUtils.changeGoblinMail(orderId, vo);
        mongoUtils.updateGoblinMailVo(mailId, vo);
        //添加日志
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.mail.update",
                        vo.getMailNo(), LocalDateTime.now(), vo.getMailId()
                )
        );
        return ResponseDto.success();
    }

    private GoblinOrderOperationLog initLog(String orderId, String uid, LocalDateTime now) {
        GoblinOrderOperationLog log = GoblinOrderOperationLog.getNew();
        log.setOrderId(orderId);
        log.setOperationName(uid);
        log.setOrderLogId(IDGenerator.nextTimeId2());
        log.setCreatedAt(now);
        return log;
    }

    private GoblinBackOrderLog initBackLog(String orderId, String uid, LocalDateTime now) {
        GoblinBackOrderLog log = GoblinBackOrderLog.getNew();
        log.setBackOrderId(orderId);
        log.setOperationName(uid);
        log.setBackOrderLogId(IDGenerator.nextTimeId2());
        log.setCreatedAt(now);
        return log;
    }

    private String initRefund(GoblinStoreOrderVo orderVo, BigDecimal price, String refundCode) {
        MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
        params.add("code", orderVo.getPayCode());
        params.add("notifyUrl", synUrl);
        params.add("orderCode", orderVo.getMasterOrderCode());
        params.add("orderRefundCode", refundCode);
        params.add("paymentId", orderVo.getPaymentId());
        params.add("paymentType", orderVo.getPaymentType());
        params.add("price", String.valueOf(price));


        BigDecimal totalPrice = BigDecimal.ZERO;
        String[] orderIds = redisUtils.getMasterCode(orderVo.getMasterOrderCode());
        for (String orderId : orderIds) {
            GoblinStoreOrderVo vo = redisUtils.getGoblinOrder(orderId);
            totalPrice = totalPrice.add(vo.getPriceActual());
        }
        params.add("priceTotal", String.valueOf(totalPrice));
        params.add("reason", "按需退款");
        MultiValueMap<String, String> headers = CollectionUtil.linkedMultiValueMapStringString();
        headers.add("Accept", "application/json;charset=UTF-8");
        String returnString = HttpUtil.post(refundApply, params, headers);
        log.debug("REFUND DATA = " + returnString);
        return returnString;
    }
}
