package com.liquidnet.service.chime.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserInfoDto
 * @Package com.liquidnet.service.chime.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/8 15:17
 */
@Data
public class ChimeUserInfoDto {
    private static final long serialVersionUID = 5325511589667456213L;
    @ApiModelProperty(position = 0, value = "用户ID[64]")
    private String userId;
    @ApiModelProperty(position = 1, value = "用户社交密码")
    private String passWord;
    @ApiModelProperty(position = 2, value = "性别")
    private String sex;
    @ApiModelProperty(position = 2, value = "用户昵称")
    private String nickName;
    @ApiModelProperty(position = 4, value = "头像")
    private String avatar;
    @ApiModelProperty(position = 4, value = "封面")
    private String userCover;
    @ApiModelProperty(position = 6, value = "生日")
    private String birthday;
    @ApiModelProperty(position = 7, value = "签名")
    private String signature;
    @ApiModelProperty(position = 8, value = "常住地/区域 ～ 已废除，参见[province、city、county]")
    private String area;
    @ApiModelProperty(position = 9, value = "在场ID")
    private String joinPerformanceId;
    @ApiModelProperty(position = 10, value = "用户标签")
    private List<ChimeUserTagDto> userTags;
    @ApiModelProperty(position = 11, value = "常住地/省 ～ 替换原字段[area]")
    private String province;
    @ApiModelProperty(position = 12, value = "常住地/市 ～ 替换原字段[area]")
    private String city;
    @ApiModelProperty(position = 13, value = "常住地/区县 ～ 替换原字段[area]")
    private String county;

    private static final ChimeUserInfoDto obj = new ChimeUserInfoDto();
    public static ChimeUserInfoDto getNew() {
        try {
            return (ChimeUserInfoDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new ChimeUserInfoDto();
        }
    }
}
