package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 会员码批次记录
 * </p>
 *
 * @author liquidnet
 * @since 2021-09-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamMemberCodeBatch implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 会员码批次号
     */
    private String batchNo;

    /**
     * ~`adam_member.member_id`
     */
    private String memberId;

    /**
     * ~`adam_member_price.member_price_id`
     */
    private String memberPriceId;

    /**
     * 会员卡名称~`adam_member.name`
     */
    private String memberName;

    /**
     * 套餐包名称
     */
    private String memberCombo;

    /**
     * 生成数量
     */
    private Integer genNum;

    /**
     * 使用数量
     */
    private Integer useNum;

    /**
     * 描述
     */
    private String describe;

    /**
     * 有效期（单位天）
     */
    private Integer validity;

    /**
     * 生效时间
     */
    private LocalDateTime effectAt;

    /**
     * 失效时间
     */
    private LocalDateTime expireAt;

    /**
     * 操作人
     */
    private String operator;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
