package com.liquidnet.service.kylin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.KylinCandyItemParam;
import com.liquidnet.service.kylin.dto.param.KylinPerformanceSubscribeParam;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinCandyVo;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * <p>
 * 演出 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
public interface IKylinPerformancesService {

    /**
     * 根据 券适用范围查询演出id
     *
     * @param useScope
     * @param busiId
     * @return
     */
    ResponseDto<String> getPerformanceIdByInfo(Integer useScope, String busiId);

    ResponseDto<String> subscribe(String performancesId, Integer sourceType);

    ResponseDto<Integer> isSubscribe(String performancesId);

    ResponseDto<List<KylinCandyVo>> kylinCandy(List<KylinCandyItemParam> data, String roadShowId);
    
    /**
     * 演出预约
     * @author zjp
     * @param param 
     * @return: com.liquidnet.service.base.ResponseDto<java.lang.String>
     * @date 2024/3/12 14:39
    */ 
    ResponseDto<String>  performanceSubscribe(HttpServletRequest request,KylinPerformanceSubscribeParam param);

    /**
     * 是否演出预约
     * @author zjp
     * @param performancesId 
     * @param ticketTimesId
     * @return: com.liquidnet.service.base.ResponseDto<java.lang.Integer>
     * @date 2024/3/6 14:45
    */
    ResponseDto<Integer> performanceIsSubscribe(String performancesId,String ticketTimesId);

    void deleteIsSubscribe(String performancesId,String ticketTimesId);
}
