package com.liquidnet.service.kylin.service.impl.admin;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import com.liquidnet.service.kylin.entity.KylinRefundBatches;
import com.liquidnet.service.kylin.entity.KylinRefunds;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketsMapper;
import com.liquidnet.service.kylin.mapper.KylinRefundsMapper;
import com.liquidnet.service.kylin.service.IKylinRefundsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 退款表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-26
 */
@Service
public class KylinRefundsServiceImpl extends ServiceImpl<KylinRefundsMapper, KylinRefunds> implements IKylinRefundsService {

    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Autowired
    private KylinRefundsStatusServiceImpl kylinRefundsStatusServiceImpl;

    public Boolean refundApply(String orderTicketsId, String orderType, String reason, String remark, Integer batch_id, String refundData) throws Exception {
        int count = 0;
        if(orderType == "order_ticket"){
            count = kylinOrderTicketsMapper.selectCount(
                    new UpdateWrapper<KylinOrderTickets>().eq("order_tickets_id", orderTicketsId).eq("coupon_type2", "full")
            );
        }
        if(count > 0){
            throw new Exception("使用满减券 暂不能退款");
        }

        if (orderType == "order_ticket") { // 票务退款
            JsonNode refundDataJson = JsonUtils.fromJson(refundData, JsonNode.class);

            JsonNode ticketEntityIds = refundDataJson.get("ticketEntityIds");

            int authId = 0;
            String authName = "sss";
            kylinRefundsStatusServiceImpl.orderTicketRefunding(authId, authName, orderTicketsId, ticketEntityIds, reason, remark, batch_id);
        }
        return true;
    }
}
