package com.liquidnet.service.dragon.channel.unionpay.strategy.impl;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.dragon.channel.unionpay.biz.UnionpayBiz;
import com.liquidnet.service.dragon.channel.unionpay.req.UnionpayTradePayReq;
import com.liquidnet.service.dragon.channel.unionpay.sdk.SDKConfig;
import com.liquidnet.service.dragon.channel.unionpay.strategy.annotation.StrategyUnionpayHandler;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: UnionpayStrategyWapImpl
 * @Package com.liquidnet.service.dragon.channel.unionpay.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/10 14:34
 */
@Slf4j
@Service
@StrategyUnionpayHandler(DragonConstant.DeviceFromEnum.WAP)
public class UnionpayStrategyWapImpl extends AbstractUnionPayStrategy {
    @Value("${liquidnet.dragon.url}")
    private String notifyUrl;

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Autowired
    private UnionpayBiz unionpayBiz;

    @Autowired
    private SDKConfig sdkConfig;

    @Override
    protected Map<String, String> executePay(UnionpayTradePayReq payReq) {
        return unionpayBiz.tradeWapPay(payReq);
    }

    @Override
    protected String getNotifyUrl() {
        return notifyUrl + "/notify/unionpay/wap";
    }

    @Override
    UnionpayTradePayReq appendRequestParam(UnionpayTradePayReq payReq, DragonPayBaseReqDto dragonPayBaseReqDto) {
        //设置订单过期时间
        String timeExpire = DateUtil.format(DateUtil.Formatter.yyyyMMddHHmmss.parse(dragonPayBaseReqDto.getCreateDate()).plusMinutes(Long.parseLong(dragonPayBaseReqDto.getExpireTime())),DateUtil.Formatter.yyyyMMddHHmmss);
        payReq.setChannelType("07");
        payReq.setRiskRateInfo(dragonPayBaseReqDto.getName());
        payReq.setFrontUrl(dragonPayBaseReqDto.getReturnUrl());
        payReq.setPayTimeout(timeExpire);
        return payReq;
    }

    @Override
    DragonPayBaseRespDto buildResponseDto(DragonPayBaseRespDto payBaseRespDto, Map<String, String> respResult) {

        payBaseRespDto.getPayData().setRedirectUrl(sdkConfig.getFrontTransUrl());
        if(StringUtil.isNotNull(respResult)){
            payBaseRespDto.getPayData().setOrderStr(JsonUtils.toJson(respResult));
        }
        return payBaseRespDto;
    }
}
