package com.liquidnet.service.dragon.channel.unionpay.strategy.impl;

import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.dragon.channel.unionpay.biz.UnionpayBiz;
import com.liquidnet.service.dragon.channel.unionpay.req.UnionpayTradePayReq;
import com.liquidnet.service.dragon.channel.unionpay.strategy.annotation.StrategyUnionpayHandler;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: UnionpayStrategyAppImpl
 * @Package com.liquidnet.service.dragon.channel.unionpay.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/11/08 18:34
 */
@Slf4j
@Component
@StrategyUnionpayHandler(DragonConstant.DeviceFromEnum.APP)
public class UnionpayStrategyAppImpl extends AbstractUnionPayStrategy {
    @Value("${liquidnet.dragon.url}")
    private String notifyUrl;

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Autowired
    private UnionpayBiz unionpayBiz;

    @Override
    protected Map<String, String> executePay(UnionpayTradePayReq payReq) {
        return unionpayBiz.tradeAppPay(payReq);
    }

    @Override
    protected String getNotifyUrl() {
        return notifyUrl + "/notify/unionpay/app";
    }

    @Override
    UnionpayTradePayReq appendRequestParam(UnionpayTradePayReq payReq, DragonPayBaseReqDto dragonPayBaseReqDto) {
        payReq.setAccType("01");
        payReq.setChannelType("08");
        return payReq;
    }

    @Override
    DragonPayBaseRespDto buildResponseDto(DragonPayBaseRespDto payBaseRespDto, Map<String, String> respResult) {
        if(StringUtil.isNotNull(respResult)&&respResult.get("tn")!=null){
            payBaseRespDto.getPayData().setPrepayId(respResult.get("tn"));
        }
        return payBaseRespDto;
    }
}
