package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.kylin.dto.param.KylinStationCheckOrderParam;
import com.liquidnet.service.kylin.dto.vo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.entity.KylinOrderTicketEntities;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketEntitiesMapper;
import com.liquidnet.service.kylin.service.IKylinOrderTicketEntitiesService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.mongodb.BasicDBObject;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 订单详情 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Service
public class KylinOrderTicketEntitiesServiceImpl extends ServiceImpl<KylinOrderTicketEntitiesMapper, KylinOrderTicketEntities> implements IKylinOrderTicketEntitiesService {
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RabbitTemplate rabbitTemplate;

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void updateByStation(KylinStationCheckOrderParam checkDataParam) {
        String performanceId = checkDataParam.getPerformanceId();

        KylinOrderTicketEntitiesVo updateVo = new KylinOrderTicketEntitiesVo();
        updateVo.setCheckClient(checkDataParam.getCheckClient());
        updateVo.setStatus(1);// 1-已出票
        List<String> checkedEntitiesIdList = checkDataParam.getCheckedEntitiesIdList();
        mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateMany(
                Query.query(Criteria.where("performanceId").is(performanceId)
                        .and("orderTicketEntitiesId").in(checkedEntitiesIdList.toArray())
                        .and("status").is(0)
                ).getQueryObject(),
                new BasicDBObject("$set", mongoConverter.convertToMongoType(updateVo))
        );

        LocalDateTime nowDt = LocalDateTime.now();

        LinkedList<Object[]> paramsList = new LinkedList<>();
        for (String id : checkedEntitiesIdList) {
            paramsList.add(new Object[]{1, nowDt, id});
        }
//        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
//                SqlMapping.get("adam_user.add", paramsList));
    }
}
