package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.entity.GoblinMix;
import com.liquidnet.service.goblin.mapper.GoblinGoodsMapper;
import com.liquidnet.service.goblin.mapper.GoblinMixMapper;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.entity.KylinRecommendActiveRelation;
import com.liquidnet.service.kylin.mapper.KylinPerformancesMapper;
import com.liquidnet.service.kylin.mapper.KylinRecommendActiveMapper;
import com.liquidnet.service.kylin.mapper.KylinRecommendActiveRelationMapper;
import com.liquidnet.service.kylin.service.admin.IKylinRecommendActiveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 推荐活动表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-27
 */
@Service
public class KylinRecommendActiveServiceImpl extends ServiceImpl<KylinRecommendActiveMapper, KylinRecommendActive> implements IKylinRecommendActiveService {
    @Autowired
    private KylinRecommendActiveMapper kylinRecommendActiveMapper;
    @Autowired
    private KylinRecommendActiveRelationMapper kylinRecommendActiveRelationMapper;
    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;
    @Autowired
    private KylinPerformancesMapper performancesMapper;
    @Autowired
    GoblinGoodsMapper goblinGoodsMapper;
    @Autowired
    GoblinMixMapper goblinMixMapper;

    @Override
    public boolean addKylinRecommendActive(KylinRecommendActive kylinRecommendActive, List<KylinRecommendActiveRelation> kylinRecommendActiveRelations) {
        //生成id
        kylinRecommendActive.setRecommendId(IDGenerator.nextSnowId());
        kylinRecommendActive.setCreatedAt(LocalDateTime.now());
        kylinRecommendActive.setUpdatedAt(LocalDateTime.now());
        kylinRecommendActive.setDelTag(0);
        kylinRecommendActiveMapper.insert(kylinRecommendActive);
        //保存推荐活动关系
        kylinRecommendActiveRelations.forEach(r->{
            r.setCreatedAt(LocalDateTime.now());
            r.setUpdatedAt(LocalDateTime.now());
            r.setDelTag(0);
            r.setRecommendActiveId(kylinRecommendActive.getRecommendId());
            kylinRecommendActiveRelationMapper.insert(r);
        });
        //更新redis数据
        this.updateRedis(kylinRecommendActive);
        return true;
    }

    @Override
    public boolean updateKylinRecommendActive(KylinRecommendActive kylinRecommendActive) {
        kylinRecommendActiveMapper.updateById(kylinRecommendActive);
        //更新redis数据
        this.updateRedis(kylinRecommendActive);
        return true;
    }

    @Override
    public List<KylinRecommendActive> pageKylinAcitve(int pageSize, int pageNumber) {
        PageHelper.startPage(pageNumber, pageSize);
        LambdaQueryWrapper<KylinRecommendActive> queryWrapper = Wrappers.lambdaQuery(KylinRecommendActive.class);
        queryWrapper.eq(KylinRecommendActive::getDelTag,0);
        List<KylinRecommendActive> list=kylinRecommendActiveMapper.selectList(queryWrapper);
        list.forEach(r->{
            //1NFT2组合购3演出4商品
            if(r.getActiveType()==1||r.getActiveType()==4){
                LambdaQueryWrapper<GoblinGoods> queryWrapperg = Wrappers.lambdaQuery(GoblinGoods.class);
                queryWrapperg.eq(GoblinGoods::getSpuId,r.getActiveBindId());
                GoblinGoods goblinGoods = goblinGoodsMapper.selectOne(queryWrapperg);
                if(null!=goblinGoods){
                    r.setName(goblinGoods.getName());
                }
            }else if(r.getActiveType()==2){
                LambdaQueryWrapper<GoblinMix> queryWrapperm = Wrappers.lambdaQuery(GoblinMix.class);
                queryWrapperm.eq(GoblinMix::getMixId,r.getActiveBindId());
                GoblinMix goblinMix = goblinMixMapper.selectOne(queryWrapperm);
                if(null!=goblinMix){
                    r.setName(goblinMix.getName());
                }
            }else if(r.getActiveType()==3){
                LambdaQueryWrapper<KylinPerformances> queryWrapperp = Wrappers.lambdaQuery(KylinPerformances.class);
                queryWrapperp.eq(KylinPerformances::getPerformancesId,r.getActiveBindId());
                KylinPerformances kylinPerformances= performancesMapper.selectOne(queryWrapperp);
                if(null!=kylinPerformances){
                    r.setName(kylinPerformances.getTitle());
                }
            }
        });
        return list;
    }

    @Override
    public KylinRecommendActive getKylinRecommendActiveById(int mid) {
        //获得推荐活动
        KylinRecommendActive kylinRecommendActive=kylinRecommendActiveMapper.selectById(mid);
        if(kylinRecommendActive.getActiveType()==1||kylinRecommendActive.getActiveType()==4){
            LambdaQueryWrapper<GoblinGoods> queryWrapperg = Wrappers.lambdaQuery(GoblinGoods.class);
            queryWrapperg.eq(GoblinGoods::getSpuId,kylinRecommendActive.getActiveBindId());
            GoblinGoods goblinGoods = goblinGoodsMapper.selectOne(queryWrapperg);
            if(null!=goblinGoods){
                kylinRecommendActive.setName(goblinGoods.getName());
            }
        }else if(kylinRecommendActive.getActiveType()==2){
            LambdaQueryWrapper<GoblinMix> queryWrapperm = Wrappers.lambdaQuery(GoblinMix.class);
            queryWrapperm.eq(GoblinMix::getMixId,kylinRecommendActive.getActiveBindId());
            GoblinMix goblinMix = goblinMixMapper.selectOne(queryWrapperm);
            if(null!=goblinMix){
                kylinRecommendActive.setName(goblinMix.getName());
            }
        }else if(kylinRecommendActive.getActiveType()==3){
            LambdaQueryWrapper<KylinPerformances> queryWrapperp = Wrappers.lambdaQuery(KylinPerformances.class);
            queryWrapperp.eq(KylinPerformances::getPerformancesId,kylinRecommendActive.getActiveBindId());
            KylinPerformances kylinPerformances= performancesMapper.selectOne(queryWrapperp);
            if(null!=kylinPerformances){
                kylinRecommendActive.setName(kylinPerformances.getTitle());
            }
        }
        //获得推荐商品
        LambdaQueryWrapper<KylinRecommendActiveRelation> queryWrapper = Wrappers.lambdaQuery(KylinRecommendActiveRelation.class);
        queryWrapper.eq(KylinRecommendActiveRelation::getRecommendActiveId,kylinRecommendActive.getRecommendId());
        queryWrapper.eq(KylinRecommendActiveRelation::getDelTag,0);
        List<KylinRecommendActiveRelation> kylinRecommendActiveRelations = kylinRecommendActiveRelationMapper.selectList(queryWrapper);
        for(KylinRecommendActiveRelation r:kylinRecommendActiveRelations){
            //1NFT2组合购3演出4商品
            if(r.getType()==1||r.getType()==4){
                LambdaQueryWrapper<GoblinGoods> queryWrapperg = Wrappers.lambdaQuery(GoblinGoods.class);
                queryWrapperg.eq(GoblinGoods::getSpuId,r.getRecommendBindId());
                GoblinGoods goblinGoods = goblinGoodsMapper.selectOne(queryWrapperg);
                if(null!=goblinGoods){
                    r.setName(goblinGoods.getName());
                }
            }else if(r.getType()==2){
                LambdaQueryWrapper<GoblinMix> queryWrapperm = Wrappers.lambdaQuery(GoblinMix.class);
                queryWrapperm.eq(GoblinMix::getMixId,r.getRecommendBindId());
                GoblinMix goblinMix = goblinMixMapper.selectOne(queryWrapperm);
                if(null!=goblinMix){
                    r.setName(goblinMix.getName());
                }
            }else if(r.getType()==3){
                LambdaQueryWrapper<KylinPerformances> queryWrapperp = Wrappers.lambdaQuery(KylinPerformances.class);
                queryWrapperp.eq(KylinPerformances::getPerformancesId,r.getRecommendBindId());
                KylinPerformances kylinPerformances= performancesMapper.selectOne(queryWrapperp);
                if(null!=kylinPerformances){
                    r.setName(kylinPerformances.getTitle());
                }
            }
        }
        kylinRecommendActive.setList(kylinRecommendActiveRelations);
        return kylinRecommendActive;
    }

    @Override
    public KylinRecommendActive getByRecommendId(String id) {
        LambdaQueryWrapper<KylinRecommendActive> queryWrapper = Wrappers.lambdaQuery(KylinRecommendActive.class);
        queryWrapper.eq(KylinRecommendActive::getRecommendId,id);
        return  kylinRecommendActiveMapper.selectOne(queryWrapper);
    }

    @Override
    public int validateTime(KylinRecommendActive kylinRecommendActive) {
        return   kylinRecommendActiveMapper.validateTime(kylinRecommendActive);
    }

    @Override
    public void updateRedis(KylinRecommendActive kylinRecommendActive) {
        //查出这个类型， 这个演出  对应配置的数据
        List<KylinRecommendActive> list= kylinRecommendActiveMapper.getBybindId(kylinRecommendActive.getActiveType(),kylinRecommendActive.getActiveBindId());
        List<KylinRecommendActive> redisList=new ArrayList<>();
        list.forEach(r->{
            //查推荐商品
            redisList.add( this.getKylinRecommendActiveById(r.getMid().intValue()));
        });
        redisDataSourceUtil.getRedisKylinUtil().set(KylinRedisConst.RECOMMEND_ACTIVE+kylinRecommendActive.getActiveBindId(), redisList);
    }
}
