package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 平台商品分类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinSelfGoodsCategory implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 分类id
     */
    private String cateId;

    /**
     * 分类名称
     */
    private String name;

    /**
     * 分类图标
     */
    private String icon;

    /**
     * 排序[数值越小,排序越前]
     */
    private Integer sort;

    /**
     * 分类层级[1-一级|2-二级|3-三级]
     */
    private String grade;

    /**
     * 分类父id
     */
    private String catePid;

    /**
     * 是否需要填写ISBN[0-否|1-是]
     */
    private String neIsbn;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;

    /**
     * 关联商品计数
     */
    private Integer counts;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String deletedBy;

    private LocalDateTime deletedAt;

    private String comment;


}
