package com.liquidnet.service.smile.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 志愿者-项目职责组志愿者关系
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SmileVolunteersTeamRelation implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 活动id
     */
    private String projectId;

    /**
     * 职责组id
     */
    private String teamId;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 补充字段
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SmileVolunteersTeamRelation obj = new SmileVolunteersTeamRelation();

    public static SmileVolunteersTeamRelation getNew() {
        try {
            return (SmileVolunteersTeamRelation) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SmileVolunteersTeamRelation();
        }
    }
}
